# python genlinkopt.py ../ libcjson32asis.opt
import sys
import glob
import os

mangleDB = {}

fdi = os.open('CXX$DEMANGLER_DB.upper', os.O_RDONLY)
r = os.read(fdi, 512)
while (r):
    mname = r[:31]
    rname = r[31:-1]
    mangleDB[rname] = [mname,]
    r = os.read(fdi, 512)
os.close(fdi)

fdi = os.open('CXX$DEMANGLER_DB.mixed', os.O_RDONLY)
r = os.read(fdi, 512)
while (r):
    mname = r[:31]
    rname = r[31:-1]
    mangleDB[rname].append(mname)
    r = os.read(fdi, 512)
os.close(fdi)

fnlst = glob.glob(sys.argv[1]+'*.c')

fo = open(sys.argv[2], 'w')

print >>fo, """! LINK
!
GSMATCH=LEQUAL,3,0
IDENTIFICATION="libcjson"
CASE_SENSITIVE=yes"""

for fn in fnlst:
    fi = open(fn)
    print >>fo, '!',fn
    for line in fi:
        if line.startswith('CJSON_PUBLIC'):
            ename = line.split(')')[1].split('(')[0].strip()
#            mname = os.popen('cxxde/repo=[.ia64.CXX_REPOSITORY]/man "'+ename+'"').read()[:-1]
            if ename in mangleDB:
                mnameu, mnamem = mangleDB[ename]
            else:
                mnamem = ename
                mnameu = ename.upper()
            print >>fo, 'SYMBOL_VECTOR=(%s=PROCEDURE)' % mnamem
            if mnameu != mnamem:
                print >>fo, 'SYMBOL_VECTOR=(%s/%s=PROCEDURE)' % (mnameu, mnamem)

