/*
 * Copyright (c) 2017 Steve Leski and contributors.
 * Copyright (c) 2019 JEan-Franois Pironne and contributors.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */


/*
 * cjson module - companion library.
 *
 * Author: Steve Leski - https://github.com/steveleski
 * Date: July 27, 2017
 *
 * This code exposes some functions to allow the user defined shareable library
 * to interact with cjson.
 *
 * IMPORTANT NOTES
 * ===============
 *
 * XXX TO DO XXX
 * =============
 *
 * Maybe I need to use a different license?
 */

#include "common_cjson.h"
#include <stdlib.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Allocate memory from a pool.
 */
CJSON_PUBLIC(void *) cjson_alloc_mem(common_cjson *context, size_t size) {
    cjson_pool_t *tmp = (cjson_pool_t*)malloc(sizeof(cjson_pool_t));
    if (context->pool != NULL) {
        tmp->next = context->pool;
    } else {
        tmp->next = NULL;
    }
    context->pool = tmp;
    tmp->value = (void *)malloc(size);

    return tmp->value;
}


/*
 * Deallocate all memory allocated from the pool. 
 *
 */
CJSON_PUBLIC(void) cjson_free_mem(common_cjson *context) {
    cjson_pool_t *tmp, *pool = context->pool;
    do {
        tmp = pool->next;
        free(pool);
        pool = tmp;
    } while  (pool != NULL);
    context->pool = NULL;
}

#ifdef __cplusplus
}
#endif
