/*
 * Copyright (c) 2017 Steve Leski and contributors.
 * Copyright (c) 2019 Jean-Franois Pironne and contributors.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */


/*
 * Apache mod_cjson module - companion header.
 *
 * Author: Steve Leski - https://github.com/steveleski
 * Date: July 27, 2017
 *
 * This header file is to be #include'd in the user defined shareable library 
 * code. It also exposes some functions to allow that code to interact with
 * mod_cjson. mod_cjson is an Apache module that can invoke a user defined
 * function to process a http request using JSON.
 *
 * to marshall/unmarshall the http request and response bodies.
 * 
 * 
 * IMPORTANT NOTES
 * ===============
 *
 * XXX TO DO XXX
 * =============
 *
 */
#ifndef _COMMON_CJSON_H_INCLUDED
#define _COMMON_CJSON_H_INCLUDED

#include "cJSON.h"
#include <stddef.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 * List of pointers malloc'ed by the framework that can be freed by mod_cjson
 * after it no longer needs the data.
 */
typedef struct cjson_pool {
    void *value;
    struct cjson_pool *next;
} cjson_pool_t;

/*
 * Context object for the cJSON api. It provides a way to pass useful
 * nuggets between cJSON and user code. This object gets passed as the first
 * parameter to the user-defined entry point.
 */
typedef struct common_cjson {
    int formatted_output;     //Make the JSON response pretty? true/false
    cjson_pool_t *pool;      //memory pool. Also used internally.
} common_cjson;

//Framework api prototypes.
void *cjson_alloc_mem(common_cjson *context, size_t size);
void cjson_free_mem(common_cjson *context);

#ifdef __cplusplus
}
#endif

#endif                          /*_COMMON_CJSON_H_INCLUDED */
