$!
$! Copyright 2011, Richard Levitte <richard@levitte.org>
$! Copyright 2014, John Malmberg <wb8tyw@qsl.net>
$! Copyright 2016, Alexander Saprykin <xelfium@gmail.com>
$! Copyright 2019, Jean-Franois Pironne <jfp@sysgroup.fr>
$!
$! Permission to use, copy, modify, and/or distribute this software for any
$! purpose with or without fee is hereby granted, provided that the above
$! copyright notice and this permission notice appear in all copies.
$!
$! THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
$! WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
$! MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
$! ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
$! WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
$! ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
$! OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
$!
$!===========================================================================
$! Command-line options:
$!
$!    32            Compile with 32-bit pointers.
$!    CCQUAL=x      Add "x" to the C compiler qualifiers.
$!    DEBUG         Build in debug mode.
$!    CLEAN         Only perform clean after the previous build.
$!    TESTS=(x)     Build library tests. Comma separated test names or leave
$!                  empty to build all the tests.
$!                  Example 1 (curtain tests): TESTS=(pmem,puthread)
$!                  Example 2 (all tests): TESTS
$!    RUN_TESTS     Runs all tests.
$!    NOLIB         Skip library buidling. Useful when you want to rebuild
$!                  particular tests.
$!===========================================================================
$!
$!
$! Save the original default dev:[dir], and arrange for its restoration
$! at exit.
$!---------------------------------------------------------------------
$ orig_def = f$environment("DEFAULT")
$ on error then goto common_exit
$ on control_y then goto common_exit
$!
$ ctrl_y       = 1556
$ proc         = f$environment("PROCEDURE")
$ proc_fid     = f$file_attributes(proc, "FID")
$ proc_dev     = f$parse(proc, , , "DEVICE")
$ proc_dir     = f$parse(proc, , , "DIRECTORY")
$ proc_name    = f$parse(proc, , , "NAME")
$ proc_type    = f$parse(proc, , , "TYPE")
$ proc_dev_dir = proc_dev + proc_dir
$!
$! Have to manually parse the device for a search list.
$! Can not use the f$parse() as it will return the first name
$! in the search list.
$!
$ orig_def_dev = f$element(0, ":", orig_def) + ":"
$ if orig_def_dev .eqs. "::" then orig_def_dev = "sys$disk:"
$ test_proc = orig_def_dev + proc_dir + proc_name + proc_type
$!
$! If we can find this file using the default directory
$! then we know that we should use the original device from the
$! default directory which could be a search list.
$!
$ test_proc_fid = f$file_attributes(test_proc, "FID")
$!
$ if (test_proc_fid .eq. proc_fid)
$ then
$     proc_dev_dir = orig_def_dev + proc_dir
$ endif
$!
$! Verbose output message stuff. Define symbol to "write sys$output".
$! vo_c - verbose output for compile
$!
$ vo_c := "write sys$output"
$!
$! Determine the main distribution directory ("[--]") in an
$! ODS5-tolerant (case-insensitive) way.  (We do assume that the only
$! "]" or ">" is the one at the end.)
$!
$! Some non-US VMS installations report ">" for the directory delimiter
$! so do not assume that it is "]".
$!
$ orig_def_len = f$length(orig_def)
$ delim = f$extract(orig_def_len - 1, 1, orig_def)
$!
$ set default 'proc_dev_dir'
$ base_src_dir = f$environment("default")
$ set default 'proc_dev_dir'
$!
$! Define the architecture-specific destination directory name
$! -----------------------------------------------------------
$!
$ if (f$getsyi("HW_MODEL") .lt. 1024)
$ then
$      'vo_c' "%LIBCJSON-F-NOTSUP, VAX platform is not supported, sorry :("
$      goto common_exit
$ else
$      arch_name = ""
$      arch_name = arch_name + f$edit(f$getsyi("ARCH_NAME"), "UPCASE")
$!
$      if (arch_name .eqs. "") then arch_name = "UNK"
$!
$      node_swvers   = f$getsyi("node_swvers")
$      version_patch = f$extract(1, f$length(node_swvers), node_swvers)
$      maj_ver       = f$element(0, ".", version_patch)
$      min_ver_patch = f$element(1, ".", version_patch)
$      min_ver       = f$element(0, "-", min_ver_patch)
$      patch         = f$element(1, "-", min_ver_patch)
$!
$      if maj_ver .lts. "7" .or. (maj_ver .eqs. "7" .and. min_ver .lts. "3")
$      then
$          'vo_c' "%LIBCJSON-F-NOTSUP, only OpenVMS 7.3 and above are supported, sorry :("
$          goto common_exit
$      endif
$ endif
$!
$ objdir = proc_dev_dir - delim + ".''arch_name'" + delim
$ confdir = proc_dev_dir
$
$ define decc$system_include tcpip$examples:, sys$library:
$ define arpa tcpip$examples: 
$ define net tcpip$examples: 
$ define netinet tcpip$examples: 
$ define sys tcpip$examples: 
$
$!
$! Parse input arguments
$! ---------------------
$! Allow arguments to be grouped together with comma or separated by spaces
$! Do no know if we will need more than 8.
$ args = "," + p1 + "," + p2 + "," + p3 + "," + p4 + ","
$ args = args + p5 + "," + p6 + "," + p7 + "," + p8 + ","
$!
$! Provide lower case version to simplify parsing.
$ args_lower = f$edit(args, "LOWERCASE,COLLAPSE")
$!
$ args_len = f$length(args)
$ args_lower_len = f$length(args_lower)
$!
$ if f$locate(",clean,", args_lower) .lt. args_lower_len
$ then
$     'vo_c' "Cleaning up previous build..."
$     set default 'proc_dev_dir'
$!
$     if f$search("''arch_name'.DIR") .nes. ""
$     then
$         set prot=w:d []'arch_name'.DIR;*
$         delete [.'arch_name'...]*.*;*,;,;,;
$         delete []'arch_name'.DIR;*
$     endif
$!
$     goto common_exit
$ endif
$!
$ build_64   = 1
$ if f$locate(",32,", args_lower) .lt. args_lower_len
$ then
$     build_64 = 0
$ endif
$!
$!
$ cc_extra = ""
$ args_loc = f$locate(",ccqual=", args_lower)
$ if args_loc .lt. args_lower_len
$ then
$     arg = f$extract(args_loc + 1, args_lower_len, args_lower)
$     arg_val = f$element(0, ",", arg)
$     cc_extra = f$element(1, "=", arg_val)
$ endif
$!
$ is_debug = 0
$ if f$locate(",debug,", args_lower) .lt. args_lower_len
$ then
$     is_debug = 1
$ endif
$!
$! Prepare build directory
$! -----------------------
$!
$! When building on a search list, need to do a create to make sure that
$! the output directory exists, since the clean procedure tries to delete
$! it.
$!
$ if f$search("''proc_dev_dir'''arch_name'.DIR") .eqs. ""
$ then
$     create/dir 'objdir'/prot=o:rwed
$ endif
$!
$ set default 'objdir'
$ if f$search("CXX_REPOSITORY.DIR") .nes. ""
$ then
$     set prot=w:d []CXX_REPOSITORY.DIR;*
$     delete [.CXX_REPOSITORY...]*.*;*
$     delete []CXX_REPOSITORY.DIR;*
$ endif
$!
$ if f$locate(",nolib,", args_lower) .lt. args_lower_len
$ then
$     goto build_tests
$ endif
$!
$! Prepare sources for compilation
$! -------------------------------
$!
$ cc_link_params = ""
$! cc_params = "/NAMES=(UPPERCASE,SHORTENED)"
$ cc_params = "/NAMES=(as_is,SHORTENED)
$ cc_params = cc_params + "/DEFINE=(_REENTRANT,_POSIX_EXIT,_OPENVMS)"
$ cc_params = cc_params + "/INCLUDE_DIRECTORY=(''objdir',''confdir',''base_src_dir')"
$ cc_params = cc_params + "/FLOAT=IEEE/IEEE_MODE=DENORM_RESULTS"
$!
$ if build_64 .eqs. "1"
$ then
$     cc_params = cc_params + "/POINTER_SIZE=64"
$ else
$     cc_params = cc_params + "/POINTER_SIZE=32"
$ endif
$!
$ if cc_extra .nes. ""
$ then
$     cc_params = cc_params + " " + cc_extra
$ endif
$!
$ if is_debug .eqs. "1"
$ then
$     cc_params = cc_params + "/DEBUG/NOOPTIMIZE/LIST/SHOW=ALL"
$     cc_link_params = "/DEBUG/TRACEBACK"
$ else
$     cc_link_params = "/NODEBUG/NOTRACEBACK"
$ endif
$!
$ cjson_src = "cJSON.c cJSON_Utils.c cJSON_VMS.c common_cjson.c"
$! Inform about building
$! ---------------------
$!
$ if build_64 .eqs. "1"
$ then
$     'vo_c' "Building for ''arch_name' (64-bit)"
$ else
$     'vo_c' "Building for ''arch_name' (32-bit)"
$ endif
$!
$! Compile library modules
$! -----------------------
$!
$ 'vo_c' "Compiling object modules..."
$ src_counter = 0
$ cjson_src = f$edit(cjson_src, "COMPRESS")
$ cjson_objs = ""
$!
$ src_loop:
$     next_src = f$element (src_counter, " ", cjson_src)
$     if next_src .nes. "" .and. next_src .nes. " "
$     then
$         'vo_c' "[CC] ''next_src'"
$         cc [--]'next_src' 'cc_params'
$!
$         src_counter = src_counter + 1
$!
$         obj_file = f$extract (0, f$length (next_src) - 1, next_src) + "obj"
$         cjson_objs = cjson_objs + "''obj_file',"
$         purge 'obj_file'
$!
$         goto src_loop
$     endif
$!
$ cjson_objs = f$extract (0, f$length (cjson_objs) - 1, cjson_objs)
$!
$! Create library
$! --------------
$!
$ libext="32"
$ if build_64 .eq. 1 then libext="64"
$ 'vo_c' "Creating object library..."
$ library/CREATE/INSERT/REPLACE /LIST=LIBCJSON'libext'.LIS LIBCJSON'libext'.OLB 'cjson_objs'
$ library/COMPRESS LIBCJSON'libext'.OLB
$ purge LIBCJSON'libext'.OLB
$ purge LIBCJSON'libext'.LIS
$!
$ 'vo_c' "Creating shared library..."
$ WRITE SYS$OUTPUT "LINK SHAREABLE"
$ link/SHARE=CJSONSHR'libext'.EXE /MAP=CJSONSHR'libext'.MAP 'cc_link_params' 'cjson_objs', [-]libcjson.opt/OPTION
$ purge CJSONSHR'libext'.EXE
$ purge CJSONSHR'libext'.MAP
$!
$! Write link options file
$! -----------------------
$!
$ if f$search("libcjson_link''libext'.opt") .nes. "" then delete libcjson'libext'_link.opt;*
$!
$ define CJSONSHR'libext 'objdir'CJSONSHR'libext'.EXE
$ open/write/error=link_write_end lhf libcjson'libext'_link.opt
$ write lhf "CJSONSHR''libext'/SHARE"
$ write lhf ""
$ link_write_end:
$     close lhf
$!
$ build_tests:
$ cjson_test = "test.c"
$!
$! Compile test files
$! -----------------------
$!
$ 'vo_c' "Compiling test files..."
$ src_counter = 0
$ cjson_test = f$edit(cjson_test, "COMPRESS")
$ cjson_objs = ""
$!
$ src_loop:
$     next_src = f$element (src_counter, " ", cjson_test)
$     if next_src .nes. "" .and. next_src .nes. " "
$     then
$         'vo_c' "[CC] ''next_src'"
$         cc [--]'next_src' 'cc_params'
$!
$         src_counter = src_counter + 1
$!
$         obj_file = f$extract (0, f$length (next_src) - 1, next_src) + "obj"
$         cjson_objs = cjson_objs + "''obj_file',"
$         purge 'obj_file'
$         link 'obj_file,libcjson'libext'_link.opt/opt
$!
$         goto src_loop
$     endif
$!
$!
$ goto build_done
$!
$ build_done:
$     'vo_c' "Build done."
$!
$ common_exit:
$     set default 'orig_def'
$     exit
