# python genlinkopt.py
import sys
import glob
import os

class SName(object):
    def __init__(self, sname, proc_stype):
        self._sname = sname
        # True if Procedure else False (if data)
        self._proc_stype = proc_stype
        self._uname = sname.upper()
        self._mgname = sname
        self._umgname = sname.upper()

    def set_mname(self, sname, mgname):
        if mgname.isupper():
            self._umgname = mgname
        else:
            self._mgname = mgname

    def symbol_vector_lines(self):
        vtype = 'PROCEDURE' if self._proc_stype else 'DATA'
        lines = 'SYMBOL_VECTOR=(%s=%s)' % (self._mgname, vtype)
        if self._mgname != self._umgname:
            lines += '\nSYMBOL_VECTOR=(%s/%s=%s)' % (self._umgname,
                                                     self._mgname,
                                                     vtype)
        return lines


AllSnames = {}

fnlst = glob.glob('../*.c')

fo = open('libcjson.opt', 'w')
foc = open('tmpnames.c', 'w')

LstNames = []

for fn in fnlst:
    if 'ftmac.h' in fn: continue
    fi = open(fn)
    for line in fi:
        line = line[:-1].strip()
        if line.startswith('CJSON_PUBLIC'):
            ename = line.split(')')[1].split('(')[0].strip()
            AllSnames[ename] = SName(ename, True)
            LstNames.append(ename)
            print >>foc, "extern %s;" % (ename,)
            print >>foc, "int %s;" % (ename,)

print >>foc, 'main() {}'
foc.close()
cmd =  'cc/noobj/name=(short,as_is)/repo=[.tmpnames] tmpnames.c'
os.popen(cmd).read()[:-1]
cmd =  'cc/noobj/name=(short,upper)/repo=[.tmpnames] tmpnames.c'
os.popen(cmd).read()[:-1]

fdi = os.open('[.tmpnames]CXX$DEMANGLER_DB.', os.O_RDONLY)
r = os.read(fdi, 512)
while (r):
    mname = r[:31]
    rname = r[31:-1]
    AllSnames[rname].set_mname(rname, mname)
    r = os.read(fdi, 512)
os.close(fdi)


print >>fo, """! LINK
!
GSMATCH=LEQUAL,3,0
IDENTIFICATION="libcjson"
CASE_SENSITIVE=yes"""

for sname in LstNames:
    print >>fo, AllSnames[sname].symbol_vector_lines()
print >>fo, """CASE_SENSITIVE=NO"""


fo.close()
os.remove('./tmpnames/CXX$DEMANGLER_DB')
os.rmdir('./tmpnames')
os.remove('tmpnames.c')
