# Changelog

## 3.3.0 - 2020-07-24

### Added

- `orjson.dumps()` now serializes individual numpy floats and integers, e.g.,
`numpy.float64(1.0)`.
- `orjson.OPT_PASSTHROUGH_DATACLASS` causes `orjson.dumps()` to pass
`dataclasses.dataclass` instances to `default`.

## 3.2.2 - 2020-07-13

### Fixed

- Fix serializing `dataclasses.dataclass` that have no attributes.

### Changed

- Improve deserialization performance of `str`.

## 3.2.1 - 2020-07-03

### Fixed

- Fix `orjson.dumps(..., **{})` raising `TypeError` on python3.6.

## 3.2.0 - 2020-06-30

### Added

- `orjson.OPT_APPEND_NEWLINE` appends a newline to output.

### Changed

- Improve deserialization performance of `str`.

## 3.1.2 - 2020-06-23

### Fixed

- Fix serializing zero-dimension `numpy.ndarray`.

## 3.1.1 - 2020-06-20

### Fixed

- Fix repeated serialization of `str` that are ASCII-only and have a legacy
(non-compact) layout.

## 3.1.0 - 2020-06-08

### Added

- `orjson.OPT_PASSTHROUGH_SUBCLASS` causes `orjson.dumps()` to pass
subclasses of builtin types to `default` so the caller can customize the
output.
- `orjson.OPT_PASSTHROUGH_DATETIME` causes `orjson.dumps()` to pass
`datetime` objects to `default` so the caller can customize the
output.

## 3.0.2 - 2020-05-27

### Changed

- `orjson.dumps()` does not serialize `dataclasses.dataclass` attributes
that begin with a leading underscore, e.g., `_attr`. This is because of the
Python idiom that a leading underscores marks an attribute as "private."
- `orjson.dumps()` does not serialize `dataclasses.dataclass` attributes that
are `InitVar` or `ClassVar` whether using `__slots__` or not.

## 3.0.1 - 2020-05-19

### Fixed

- `orjson.dumps()` raises an exception if the object to be serialized
is not given as a positional argument. `orjson.dumps({})` is intended and ok
while `orjson.dumps(obj={})` is an error. This makes it consistent with the
documentation, `help()` annotation, and type annotation.
- Fix orphan reference in exception creation that leaks memory until the
garbage collector runs.

### Changed

- Improve serialization performance marginally by using the fastcall/vectorcall
calling convention on python3.7 and above.
- Reduce build time.

## 3.0.0 - 2020-05-01

### Added

- `orjson.dumps()` serializes subclasses of `str`, `int`, `list`, and `dict`.

### Changed

- `orjson.dumps()` serializes `dataclasses.dataclass` and `uuid.UUID`
instances by default. The options `OPT_SERIALIZE_DATACLASS` and
`OPT_SERIALIZE_UUID` can still be specified but have no effect.

## 2.6.8 - 2020-04-30

### Changed

- The source distribution vendors a forked dependency.

## 2.6.7 - 2020-04-30

### Fixed

- Fix integer overflows in debug builds.

### Changed

- The source distribution sets the recommended RUSTFLAGS in `.cargo/config`.

## 2.6.6 - 2020-04-24

### Fixed

- Import `numpy` only on first use of `OPT_SERIALIZE_NUMPY` to reduce
interpreter start time when not used.
- Reduce build time by half.

## 2.6.5 - 2020-04-08

### Fixed

- Fix deserialization raising `JSONDecodeError` on some valid negative
floats with large exponents.

## 2.6.4 - 2020-04-08

### Changed

- Improve deserialization performance of floats by about 40%.

## 2.6.3 - 2020-04-01

### Changed

- Serialize `enum.Enum` objects.
- Minor performance improvements.

## 2.6.2 - 2020-03-27

### Changed

- Publish python3.9 `manylinux2014` wheel instead of `manylinux1` for `x86_64`.
- Publish python3.9 `manylinux2014` wheel for `aarch64`.

### Fixed

- Fix compilation failure on 32-bit.

## 2.6.1 - 2020-03-19

### Changed

- Serialization is 10-20% faster and uses about 50% less memory by writing
directly to the returned `bytes` object.

## 2.6.0 - 2020-03-10

### Added

- `orjson.dumps()` pretty prints with an indentation of two spaces if
`option=orjson.OPT_INDENT_2` is specified.

## 2.5.2 - 2020-03-07

### Changed

- Publish `manylinux2014` wheels for `aarch64`.
- numpy support now includes `numpy.uint32` and `numpy.uint64`.

## 2.5.1 - 2020-02-24

### Changed

- `manylinux1` wheels for 3.6, 3.7, and 3.8 are now compliant with the spec by
not depending on glibc 2.18.

## 2.5.0 - 2020-02-19

### Added

- `orjson.dumps()` serializes `dict` keys of type other than `str` if
`option=orjson.OPT_NON_STR_KEYS` is specified.

## 2.4.0 - 2020-02-14

### Added

- `orjson.dumps()` serializes `numpy.ndarray` instances if
`option=orjson.OPT_SERIALIZE_NUMPY` is specified.

### Fixed

- Fix `dataclasses.dataclass` attributes that are `dict` to be effected by
`orjson.OPT_SORT_KEYS`.

## 2.3.0 - 2020-02-12

### Added

- `orjson.dumps()` serializes `dict` instances sorted by keys, equivalent to
`sort_keys` in other implementations, if `option=orjson.OPT_SORT_KEYS` is
specified.

### Changed

- `dataclasses.dataclass` instances without `__slots__` now serialize faster.

### Fixed

- Fix documentation on `default`, in particular documenting the need to raise
an exception if the type cannot be handled.

## 2.2.2 - 2020-02-10

### Changed

- Performance improvements to serializing a list containing elements of the
same type.

## 2.2.1 - 2020-02-04

### Fixed

- `orjson.loads()` rejects floats that do not have a digit following
the decimal, e.g., `-2.`, `2.e-3`.

### Changed

- Build Linux, macOS, and Windows wheels on more recent distributions.

## 2.2.0 - 2020-01-22

### Added

- `orjson.dumps()` serializes `uuid.UUID` instances if
`option=orjson.OPT_SERIALIZE_UUID` is specified.

### Changed

- Minor performance improvements.
- Publish Python 3.9 wheel for Linux.

## 2.1.4 - 2020-01-08

### Fixed

- Specify a text signature for `orjson.loads()`.

### Changed

- Improve documentation.

## 2.1.3 - 2019-11-12

### Changed

- Publish Python 3.8 wheels for macOS and Windows.

## 2.1.2 - 2019-11-07

### Changed

- The recursion limit of `default` on `orjson.dumps()` has been increased from
5 to 254.

## 2.1.1 - 2019-10-29

### Changed

- Publish `manylinux1` wheels instead of `manylinux2010`.

## 2.1.0 - 2019-10-24

### Added

- `orjson.dumps()` serializes `dataclasses.dataclass` instances if
`option=orjson.OPT_SERIALIZE_DATACLASS` is specified.
- `orjson.dumps()` accepts `orjson.OPT_UTC_Z` to serialize UTC as "Z" instead
of "+00:00".
- `orjson.dumps()` accepts `orjson.OPT_OMIT_MICROSECONDS` to not serialize
the `microseconds` attribute of `datetime.datetime` and `datetime.time`
instances.
- `orjson.loads()` accepts `bytearray`.

### Changed

- Drop support for Python 3.5.
- Publish `manylinux2010` wheels instead of `manylinux1`.

## 2.0.11 - 2019-10-01

### Changed

- Publish Python 3.8 wheel for Linux.

## 2.0.10 - 2019-09-25

### Changed

- Performance improvements and lower memory usage in deserialization
by creating only one `str` object for repeated map keys.

## 2.0.9 - 2019-09-22

### Changed

- Minor performance improvements.

### Fixed

- Fix inaccurate zero padding in serialization of microseconds on
`datetime.time` objects.

## 2.0.8 - 2019-09-18

### Fixed

- Fix inaccurate zero padding in serialization of microseconds on
`datetime.datetime` objects.

## 2.0.7 - 2019-08-29

### Changed

- Publish PEP 517 source distribution.

### Fixed

- `orjson.dumps()` raises `JSONEncodeError` on circular references.

## 2.0.6 - 2019-05-11

### Changed

- Performance improvements.

## 2.0.5 - 2019-04-19

### Fixed

- Fix inaccuracy in deserializing some `float` values, e.g.,
31.245270191439438 was parsed to 31.24527019143944. Serialization was
unaffected.

## 2.0.4 - 2019-04-02

### Changed

- `orjson.dumps()` now serializes `datetime.datetime` objects without a
`tzinfo` rather than raising `JSONEncodeError`.

## 2.0.3 - 2019-03-23

### Changed

- `orjson.loads()` uses SSE2 to validate `bytes` input.

## 2.0.2 - 2019-03-12

### Changed

- Support Python 3.5.

## 2.0.1 - 2019-02-05

### Changed

- Publish Windows wheel.

## 2.0.0 - 2019-01-28

### Added

- `orjson.dumps()` accepts a `default` callable to serialize arbitrary
types.
- `orjson.dumps()` accepts `datetime.datetime`, `datetime.date`,
and `datetime.time`. Each is serialized to an RFC 3339 string.
- `orjson.dumps(..., option=orjson.OPT_NAIVE_UTC)` allows serializing
`datetime.datetime` objects that do not have a timezone set as UTC.
- `orjson.dumps(..., option=orjson.OPT_STRICT_INTEGER)` available to
raise an error on integer values outside the 53-bit range of all JSON
implementations.

### Changed

- `orjson.dumps()` no longer accepts `bytes`.

## 1.3.1 - 2019-01-03

### Fixed

- Handle invalid UTF-8 in str.

## 1.3.0 - 2019-01-02

### Changed

- Performance improvements of 15-25% on serialization, 10% on deserialization.

## 1.2.1 - 2018-12-31

### Fixed

- Fix memory leak in deserializing dict.

## 1.2.0 - 2018-12-16

### Changed

- Performance improvements.

## 1.1.0 - 2018-12-04

### Changed

- Performance improvements.

### Fixed

- Dict key can only be str.

## 1.0.1 - 2018-11-26

### Fixed

- pyo3 bugfix update.

## 1.0.0 - 2018-11-23

### Added

- `orjson.dumps()` function.
- `orjson.loads()` function.
