#ifndef XA_H
#define XA_H
/*
 * $Id: xa.h,v 1.2 2003/02/13 11:56:05 lsmithso Exp $
 * The standard XA Switch structure, from the XA spec.
 *
 * Author: L. Smithson (lsmithson@open-networks.co.uk)
 *
 * DISCLAIMER
 * You are free to use this code in any way you like, subject to the
 * Python disclaimers & copyrights. I make no representations about
 * the suitability of this software for any purpose. It is provided
 * "AS-IS" without warranty of any kind, either express or implied. So
 * there.
 */

#define XIDDATASIZE 128
#define MAXGTRIDSIZE 64	
#define MAXBQUALSIZE 64	

/*
 * Transaction Id
 */
struct xid_t {
  long	formatID;
  long	gtrid_length;
  long	bqual_length;
  char	data[XIDDATASIZE];
};

typedef struct xid_t XID;

/*
 * XA Switch Data Structure
 */
#define RMNAMESZ 32

struct xa_switch_t {
  char name[RMNAMESZ];
  long flags;		
  long version;		

  /*
   * The jump table
   */
  int (*xa_open_entry)(char *, int, long);  
  int (*xa_close_entry)(char *, int, long); 
  int (*xa_start_entry)(XID *, int, long); 
  int (*xa_end_entry)(XID *, int, long);   
  int (*xa_rollback_entry)(XID *, int, long);
  int (*xa_prepare_entry)(XID *, int, long); 
  int (*xa_commit_entry)(XID *, int, long);  
  int (*xa_recover_entry)(XID *, long, int, long);
  int (*xa_forget_entry)(XID *, int, long);	
  int (*xa_complete_entry)(int *, int *, int, long);
};


  
#endif 
