/*
 * $Id: mqorapysw.c,v 1.1 2003/02/07 17:09:32 lsmithso Exp $
 * mqorasw.c: Sample call to pyxasw, using the Oracle RM xaosw and MQ TM.
 *
 *
 * Author: L. Smithson (lsmithson@open-networks.co.uk)
 *
 * DISCLAIMER
 * You are free to use this code in any way you like, subject to the
 * Python disclaimers & copyrights. I make no representations about
 * the suitability of this software for any purpose. It is provided
 * "AS-IS" without warranty of any kind, either express or implied. So
 * there.
 */

#include <cmqc.h>
#include "pyxasw.h"
#include "xa.h"

/*
 * The Oracle RM XA switch instance
 */
extern struct xa_switch_t xaosw;

/*
 * MQ's TM calls this to register a RM interface
 */
struct xa_switch_t *MQStart(void) {

  /*
   * Start the embedded Python interp, load the Python module
   * 'pyxademo', wrap the Oracle XA switch in a Python one and return it.
   */
  return pyxasw_Wrapper(&xaosw, "pyxademo");
}
