#
# $Id: pyxademo.py,v 1.2 2003/02/13 11:59:08 lsmithso Exp $
# A demo Python script called by mqorasw.c.
#
# Author: L. Smithson (lsmithson@open-networks.co.uk)
#
# DISCLAIMER
# You are free to use this code in any way you like, subject to the
# Python disclaimers & copyrights. I make no representations about
# the suitability of this software for any purpose. It is provided
# "AS-IS" without warranty of any kind, either express or implied. So
#  there.
#

#
# We don't have a tty. so use the Unix syslog to measure our progess.
#
import syslog, sys

#
# Import the 'extension' bit of pyxasw so we can make the real XA RM
# calls.
#
import pyxasw

#
# Define some of embedded XA functions. Those that are not defined
# default to the wrapped XA switch.
#

# Open connection to RM
def xa_open(openString, rmid, flags):
    syslog.syslog("xa_open - openString: %s, rmid: %d, flags: %ld" %
                  (openString, rmid, flags))

    # Call the extension open call, passing the params along.
    retval = pyxasw.rmopen(openString, rmid, flags)
    syslog.syslog("rmopen returned %d" % retval)
    return retval

# Start a new transaction
def xa_start(xid, rmid, flags):
    syslog.syslog("xa_start - xid: %s, rmid: %d, flags: %ld" % (pyxasw.xid2str(xid), rmid, flags))
    retval = pyxasw.rmstart(xid, rmid, flags)
    syslog.syslog("rmstart returned %d" % retval)
    return retval

# End a transaction
def xa_end(xid, rmid, flags):
    syslog.syslog("xa_end - xid: %s, rmid: %d, flags: %ld" % (pyxasw.xid2str(xid), rmid, flags))
    retval = pyxasw.rmend(xid, rmid, flags)
    syslog.syslog("rmend returned %d" % retval)
    return 0
    

# Prepare a transaction
def xa_prepare(xid, rmid, flags):
    syslog.syslog("xa_prepare - xid: %s, rmid: %d, flags: %ld" % (pyxasw.xid2str(xid), rmid, flags))
    retval = pyxasw.rmprepare(xid, rmid, flags)
    syslog.syslog("rmprepare returned %d" % retval)
    return retval

# Commit a transaction
def xa_commit(xid, rmid, flags):
    syslog.syslog("xa_commit - xid: %s, rmid: %d, flags: %ld" % (pyxasw.xid2str(xid), rmid, flags))
    retval = pyxasw.rmcommit(xid, rmid, flags)
    syslog.syslog("rmcommit returned %d" % retval)
    return retval

# Rollback a transaction
def xa_rollback(xid, rmid, flags):
    syslog.syslog("xa_rollback - xid: %s, rmid: %d, flags: %ld" % (pyxasw.xid2str(xid), rmid, flags))
    retval = pyxasw.rmrollback(xid, rmid, flags)
    syslog.syslog("rmrollback returned %d" % retval)
    return retval

#
# Rest default to wrapped XA calls.
#
