from vms import starlet, ssdef


class DisplayProxy(object):
    def __init__(self, rem_node='*', rem_user='*', flags=0):
        self.rem_node = rem_node
        self.rem_user = rem_user
        self.flags = 0
        self.contxt = 0

    def __enter__(self):
        return self

    def __exit__(self, exc_type, exc_value, traceback):
        return

    def __iter__(self):
        return self

    def __next__(self):
        s, proxy_node, proxy_user, default_user, local_users, self.contxt = \
                starlet.display_proxy(self.rem_node, self.rem_user, self.flags, self.contxt)
        if s == ssdef.SS__NOMOREITEMS: 
            raise StopIteration
        return proxy_node, proxy_user, default_user, local_users
     
    def next(self):
        return self.__next__()


if __name__ == '__main__':
    with DisplayProxy() as idp:
        for dp in idp:
            print dp
    for dp in DisplayProxy():
        print dp
