from vms import starlet, ssdef


class IdToAsc(object):
    def __init__(self):
        self.contxt = 0
        self.iid = None

    def __enter__(self):
        self.contxt = 0
        self.iid = 0xFFFFFFFF  # do a wildcard lookup
        return self

    def __exit__(self, exc_type, exc_value, traceback):
        starlet.finish_rdb(self.contxt)

    def __iter__(self):
        return self

    def __next__(self):
        try:
            s, idname, rid, attrib, self.contxt = \
                starlet.idtoasc(self.iid, self.contxt)
            return self.uictoasc(rid) if (rid < 0x80000000L) else "%s" % idname
        except VMSError, e:
            raise StopIteration if e.errno == ssdef.SS__NOSUCHID else e
     
    def next(self):
        return self.__next__()

    def uictoasc(self, uic_value):
        high_word = int(uic_value / 65536)
        low_word  = int(uic_value - (high_word * 65536))
        # Note: [1:], because octal values will be preceeded by '0'
        high_word = '0' if high_word == 0 else oct(high_word)[1:]
        low_word = '0' if low_word == 0 else oct(low_word)[1:]
        return  '[' + high_word + ',' + low_word  + ']'


if __name__ == '__main__':
    with IdToAsc() as iid:
        for idnam in iid:
            print idnam
