from vms import starlet
from vms import itemList, ossdef, ssdef
from vms.rtl import lib

def get_security(fn, clsnam='FILE'):
    itm = [itemList.itemList (code=ossdef.OSS__ACL_READ), 
           itemList.itemList (code=ossdef.OSS__PROTECTION, dtype=itemList.il_unsignedWord),
           itemList.itemList (code=ossdef.OSS__OWNER, dtype=itemList.il_unsignedLong)]
    accnam = lib.get_accnam(clsnam)[1]

    s,res = starlet.get_security (clsnam, fn, itmlst=itm)
    try:
        own = starlet.idtoasc(res[ossdef.OSS__OWNER])[1]
    except:
        own = res[ossdef.OSS__OWNER]
        high_word = int(own / 65536)
        low_word  = int(own - (high_word *65536))
        own = "[%o,%o]" % (high_word, low_word)
    prot = lib.format_sogw_prot(res[ossdef.OSS__PROTECTION], access_names=accnam)[1]
    acl = []
    v = res[ossdef.OSS__ACL_READ]
    while v != '':
        acl.append(starlet.format_acl(v[:ord(v[0]) - 1], accnam=accnam)[1])
        v = v[ord(v[0]):]
    return own, prot, acl

if __name__ == '__main__':
    import sys
    filename = sys.argv[1]
    clsnam = sys.argv[2]
    owner, protection, acl = get_security(filename, clsnam)
    print '    Owner:', owner
    print '    Protection:', protection
    print '    Access control list:'
    for e in acl:
        print 9*' ', e
