from vms import starlet, ssdef
from vms import dvsdef
from vms import itemList


class DeviceScan(object):
    def __init__(self, search_devnam=None, devclass=None, devtype=None):
        self.search_devnam = search_devnam
        if devclass:
            self.itmlst = [itemList.itemList(code=dvsdef.DVS__DEVCLASS,
                                             value=devclass),]
            if devtype:
                self.itmlst.append(itemList.itemList(code=dvsdef.DVS__DEVTYPE,
                                                     value=devtype))
        elif devtype:
            self.itmlst = [itemList.itemList(code=dvsdef.DVS__DEVTYPE,
                                             value=devtype),]
        else:
            self.itmlst = None            
        self.contxt = 0

    def __enter__(self):
        return self

    def __exit__(self, exc_type, exc_value, traceback):
        return

    def __iter__(self):
        return self

    def __next__(self):
        try:
            s, devnam, self.contxt = \
                 starlet.device_scan(self.search_devnam, self.itmlst,
                                     self.contxt)
        except VMSError, e:
            raise StopIteration if e.errno == ssdef.SS__NOMOREDEV else e
        return devnam
     
    def next(self):
        return self.__next__()

if __name__ == '__main__':
    import sys
    from vms.dcdef import DC__DISK
    with DeviceScan(sys.argv[1]) as idev:
        for devnam in idev:
            print devnam
    print
    for devnam in DeviceScan(sys.argv[1], devclass=DC__DISK):
        print devnam
