# -*- coding: iso-8859-1 -*-
__version__ = '1.0'
#__all__ = ['rule1201', 'rule1202', 'rule1203']

from common import level_rule
from vms.rtl import lib
from vms import syidef, uaidef, prvdef, dvidef, ossdef
from vms import user
from vms import starlet
from vms import itemList
from vms import crtl

@level_rule(1)
def rule0101(fo, ftm):
    """The following system-level accounts do not have account restrictions defined.

Improper configuration of access restrictions could result in the compromise of
the operating system environment, and compromise the confidentiality of customer data"""

    maxsysgroup = lib.getsyi(syidef.SYI__MAXSYSGROUP)[1]
    all_users = user.all_users()

    if not ftm:
        print >>fo, 'Rule 0101'
        print >>fo, '========='
    for u in all_users.values():    
        if (u.uic_group <= maxsysgroup) and (u.dialup_access_p != '\xff\xff\xff'):
            if ftm:
                print >>fo, '01011 %-12s [%o,%o]' % (u.username, u.uic_group, u.uic_member)
            else:
                print >>fo, '%-12s [%o,%o]' % (u.username, u.uic_group, u.uic_member)

@level_rule(2)
def rule0102(fo, ftm):
    """The accounts listed have duplicate UICs.  This is a security problem.  
Accounts that share a common UIC allow the user of one account 
to modify or delete the files of another account"""

    all_users = user.all_users()

    if not ftm:
        print >>fo
        print >>fo, 'Rule 0102'
        print >>fo, '========='
    uics = {}
    for u in all_users.values(): 
        uic = '[%o,%o]' % (u.uic_group, u.uic_member)
        if uic in uics:
            uics[uic].append(u.username)
        else:
            uics[uic] = [u.username,]
    
    for uic in uics:
        if len(uics[uic]) > 1:
            if ftm:
                print >>fo, '01022', uic, uics[uic]
            else:
                print >>fo, uic, uics[uic]
    
@level_rule(3)
def rule0103(fo, ftm):
    """Most accounts with these types of privileges are not part of the normal 
operating system distribution and can represent a security risk."""

    maxsysgroup = lib.getsyi(syidef.SYI__MAXSYSGROUP)[1]
    all_users = user.all_users()

    if not ftm:
        print >>fo
        print >>fo, 'Rule 0103'
        print >>fo, '========='
    for u in all_users.values():
        if (u.uic_group <= maxsysgroup):
            if (u.priv | u.def_priv) & (prvdef.PRV_M_GROUP | prvdef.PRV_M_GRPPRV):
                if ftm:
                    print >>fo, '01033', u.username
                else:
                    print >>fo, u.username

@level_rule(3)
def rule0104(fo, ftm):
    """A system level UIC is one in which the group number is less than, 
or equal to, the SYSGEN parameter, MAXSYSGROUP.  The group number is 
defined at system generation time and may vary from site to site.
Account privileges allow users to add, modify or delete system files.  
These accounts are not part of the normal operating 
system distribution and can represent a security risk."""

    maxsysgroup = lib.getsyi(syidef.SYI__MAXSYSGROUP)[1]
    all_users = user.all_users()

    if not ftm:
        print >>fo
        print >>fo, 'Rule 0104'
        print >>fo, '========='
    for u in all_users.values():
        if (u.uic_group <= maxsysgroup) and (u.username != 'SYSTEM'):
            if ftm:
                print >>fo, '01043', u.username
            else:
                print >>fo, u.username
    
@level_rule(3)
def rule0105(fo, ftm):
    """Improperly granted privilege classes can grant unintended 
privileges and accesses to users.  This could result in the 
compromise of the operating system environment, and compromise 
the confidentiality of customer data."""

    maxsysgroup = lib.getsyi(syidef.SYI__MAXSYSGROUP)[1]
    all_users = user.all_users()

    if ftm:
        print >>fo
        print >>fo, 'Rule 0105'
        print >>fo, '========='

    privs = (prvdef.PRV_M_CMKRNL |
             prvdef.PRV_M_CMEXEC |
             prvdef.PRV_M_SYSNAM |
             prvdef.PRV_M_GRPNAM |
             prvdef.PRV_M_ALLSPOOL |
             prvdef.PRV_M_IMPERSONATE |
             prvdef.PRV_M_DIAGNOSE |
             prvdef.PRV_M_LOG_IO |
             prvdef.PRV_M_GROUP |
             prvdef.PRV_M_NOACNT |
             prvdef.PRV_M_PRMCEB |
             prvdef.PRV_M_PRMMBX |
             prvdef.PRV_M_PSWAPM |
             prvdef.PRV_M_SETPRI |
             prvdef.PRV_M_SETPRV |
             prvdef.PRV_M_WORLD |
             prvdef.PRV_M_MOUNT |
             prvdef.PRV_M_OPER |
             prvdef.PRV_M_EXQUOTA |
             prvdef.PRV_M_VOLPRO |
             prvdef.PRV_M_PHY_IO |
             prvdef.PRV_M_BUGCHK |
             prvdef.PRV_M_PRMGBL |
             prvdef.PRV_M_SYSGBL |
             prvdef.PRV_M_PFNMAP |
             prvdef.PRV_M_SHMEM |
             prvdef.PRV_M_SYSPRV |
             prvdef.PRV_M_BYPASS |
             prvdef.PRV_M_SYSLCK |
             prvdef.PRV_M_SHARE |
             prvdef.PRV_M_UPGRADE |
             prvdef.PRV_M_DOWNGRADE |
             prvdef.PRV_M_GRPPRV |
             prvdef.PRV_M_READALL |
             prvdef.PRV_M_IMPORT |
             prvdef.PRV_M_AUDIT |
             prvdef.PRV_M_SECURITY)
    
    for u in all_users.values():
        if (u.uic_group > maxsysgroup):
            if (u.priv | u.def_priv) & privs:
                if ftm:
                    print >>fo, '01053', u.username
                else:
                    print >>fo, u.username
    
@level_rule(3)
def rule0106(fo, ftm):
    """These accounts may no longer be valid or useful, and may 
represent a security exposure to the system."""

    all_users = user.all_users()

    if not ftm:
        print >>fo
        print >>fo, 'Rule 0106'
        print >>fo, '========='
    for u in all_users.values():
        try:
            lib.getdvi(dvidef.DVI__DEVNAM, None, u.defdev)
        except:
            if ftm:
                print >>fo, '01063', u.username
            else:
                print >>fo, u.username, u.defdev

@level_rule(3)
def rule0107(fo, ftm):
    """The device may not be online, mounted or available.  
Security checks cannot be completed."""

    all_users = user.all_users()

    if ftm:
        print >>fo
        print >>fo, 'Rule 0107'
        print >>fo, '========='
    for u in all_users.values():
        try:
            lib.getdvi(dvidef.DVI__AVL, None, u.defdev)
        except:
            if ftm:
                print >>fo, '01073', u.username
            else:
                print >>fo, u.username, u.defdev

@level_rule(2)
def rule0108(fo, ftm):
    """Improper home directory configuration can interfere with 
the proper functioning of accounts.  The accounts listed do not 
have home directories.  This is not consistent with the system 
configuration.  These accounts may be inactive or DISUSERed."""

    all_users = user.all_users()

    if not ftm:
        print >>fo
        print >>fo, 'Rule 0108'
        print >>fo, '========='
    for u in all_users.values():
        if (u.defdir == '') and (u.defdev == ''):
            if ftm:
                print >>fo, '01082', u.username
            else:
                print >>fo, u.username

@level_rule(3)
def rule0109(fo, ftm):
    """Improper account ownership can prevent proper identification 
of assigned privileges, result in auditing difficulties, and can 
jeopardize overall system security."""

    all_users = user.all_users()

    if not ftm:
        print >>fo
        print >>fo, 'Rule 0109'
        print >>fo, '========='
    
    privs = prvdef.PRV_M_TMPMBX | prvdef.PRV_M_NETMBX
    u = all_users['DEFAULT']
    if (u.def_priv != u.priv) or (u.priv & ~privs) or (u.flags & uaidef.UAI_M_DISACNT) == 0:
        if ftm:
            print >>fo, '01093', u.username
        else:
            print >>fo, u.username
    
    privs = (prvdef.PRV_M_TMPMBX | 
             prvdef.PRV_M_NETMBX |
             prvdef.PRV_M_ALLSPOOL |
             prvdef.PRV_M_DIAGNOSE |
             prvdef.PRV_M_PHY_IO |
             prvdef.PRV_M_GROUP |
             prvdef.PRV_M_PRMCEB |
             prvdef.PRV_M_GRPNAM |
             prvdef.PRV_M_PRMMBX |
             prvdef.PRV_M_LOG_IO |
             prvdef.PRV_M_SETPRV)
    if 'FIELD' in all_users:
        u = all_users['FIELD']
        if (u.def_priv != u.priv) or (u.priv & ~privs) or (u.flags & uaidef.UAI_M_DISACNT) == 0:
            if ftm:
                print >>fo, '01093', u.username
            else:
                print >>fo, u.username
        
    privs = (prvdef.PRV_M_CMEXEC |
             prvdef.PRV_M_IMPERSONATE |
             prvdef.PRV_M_PRMMBX |
             prvdef.PRV_M_VOLPRO |
             prvdef.PRV_M_CMKRNL |
             prvdef.PRV_M_LOG_IO |
             prvdef.PRV_M_SETPRV |
             prvdef.PRV_M_DIAGNOSE |
             prvdef.PRV_M_NETMBX |
             prvdef.PRV_M_SYSNAM |
             prvdef.PRV_M_GROUP |
             prvdef.PRV_M_PHY_IO |
             prvdef.PRV_M_SYSPRV |
             prvdef.PRV_M_GRPNAM |
             prvdef.PRV_M_PRMCEB |
             prvdef.PRV_M_TMPMBX)
    
    if 'SYSTEST' in all_users:
        u = all_users['SYSTEST']
        if (u.def_priv != u.priv) or (u.priv & ~privs) or (u.flags & uaidef.UAI_M_DISACNT) == 0:
            if ftm:
                print >>fo, '01093', u.username
            else:
                print >>fo, u.username
    
    if 'SYSTEST_CLIG' in all_users:
        u = all_users['SYSTEST_CLIG']
        if (u.def_priv != u.priv) or (u.priv & ~privs) or (u.flags & uaidef.UAI_M_DISACNT) == 0:
            if ftm:
                print >>fo, '01093', u.username
            else:
                print >>fo, u.username
    
@level_rule(3)
def rule0110(fo, ftm):
    """ Improper configuration of account related SYSGEN parameters 
could result in the compromise of the operating system environment, 
and compromise the confidentiality of customer data."""

    maxsysgroup = lib.getsyi(syidef.SYI__MAXSYSGROUP)[1]

    if not ftm:
        print >>fo
        print >>fo, 'Rule 0110'
        print >>fo, '========='
    
    load_pwd_policy = lib.getsyi(syidef.SYI__LOAD_PWD_POLICY)[1]
    rms_fileprot = lib.getsyi(syidef.SYI__RMS_FILEPROT)[1]
    
    if (load_pwd_policy != 0):
        if ftm:
            print >>fo, '01103LOAD_PWD_POLICY', load_pwd_policy 
        else:
            print >>fo, 'LOAD_PWD_POLICY invalid', load_pwd_policy 
    if (maxsysgroup > 8):
        if ftm:
            print >>fo, '01103MAXSYSGROUP', maxsysgroup
        else:
            print >>fo, 'MAXSYSGROUP invalid' , maxsysgroup
    if (rms_fileprot != 65280):
        if ftm:
             print >>fo, '01103RMS_FILEPROT', lib.format_sogw_prot (rms_fileprot)[1]
        else:
            print >>fo, 'RMS_FILEPROT invalid found', lib.format_sogw_prot (rms_fileprot)[1]
            print >>fo, '                   waiting', lib.format_sogw_prot (65280)[1]
    
    
if __name__ == '__main__':
    import sys
    fo = open(sys.argv[1], 'w') if len(sys.argv) > 1 else sys.stdout
    rule0101(fo, len(sys.argv) > 2)
    rule0102(fo, len(sys.argv) > 2)
    rule0103(fo, len(sys.argv) > 2)
    rule0104(fo, len(sys.argv) > 2)
    rule0105(fo, len(sys.argv) > 2)
    rule0106(fo, len(sys.argv) > 2)
    rule0107(fo, len(sys.argv) > 2)
    rule0108(fo, len(sys.argv) > 2)
    rule0109(fo, len(sys.argv) > 2)
    rule0110(fo, len(sys.argv) > 2)
