# -*- coding: iso-8859-1 -*-
__version__ = '1.0'

from common import level_rule
import os, os.path
from vms.rtl import lib
from vms import syidef, uaidef, prvdef, dvidef, ossdef, ssdef
from vms import user
from vms import starlet
from vms import itemList
from vms import crtl
from FindFile import FindFile


@level_rule(2)
def rule0201(fo, fmt):
    """ Improper system file access could result in the compromise of 
the operating system environment, and compromise the confidentiality 
of customer data.  The files listed are accessible by non-privileged 
users as indicated.  This allows non-privileged users to read, execute, 
modify, or delete the files.  Users can gain access using an ACL granted 
to the user, the privilege of the user, or the UIC protection on the file."""

    if not fmt:
        print>>fo
        print>>fo, 'Rule 0201'
        print>>fo, '========='

    with FindFile('SYS$SYSROOT:[000000...]*.*') as fi:
        for fn in fi:
            it = [itemList.itemList(code = ossdef.OSS__PROTECTION, dtype = itemList.il_unsignedWord),]
            try:
                sec = starlet.get_security(objnam=fn, clsnam='FILE',
                                           itmlst=it)[1][ossdef.OSS__PROTECTION]
                if not ((sec & 0x8000) and (sec & 0x2000)):
                    if fmt:
                        print>>fo, '02012', fn
                    else:
                        print>>fo, fn
                        print>>fo, ' ' * 10, lib.format_sogw_prot (sec)[1]
            except VMSError, e:
                if e.errno != ssdef.SS__NOSUCHFILE:
                    raise

@level_rule(3)
def rule0202(fo, fmt):
    """ Improper system file access could result in the compromise of the 
operating system environment, and compromise the confidentiality of customer 
data.  The listed files are accessible by privileged users as indicated.  
This allows privileged users to read, execute, modify, or delete the files.  
Users can gain access using an ACL granted to the user, the privilege of the 
user, or the UIC protection on the file."""

    if not fmt:
        print>>fo
        print>>fo, 'Rule 0202'
        print>>fo, '========='

    with FindFile('SYS$SYSROOT:[000000...]*.*') as fi:
        for fn in fi:
            it = [itemList.itemList (code = ossdef.OSS__PROTECTION, dtype = itemList.il_unsignedWord),]
            sec = starlet.get_security (objnam=fn, clsnam='FILE',itmlst=it)[1][ossdef.OSS__PROTECTION]
            if not ((sec & 0x800) and (sec & 0x200)):
                if fmt:
                    print>>fo, '02023', fn
                else:
                    print>>fo, fn
                    print>>fo, ' ' * 10, lib.format_sogw_prot (sec)[1]

if __name__ == '__main__':
    import sys
    fo = open(sys.argv[1], 'w') if len(sys.argv) > 1 else sys.stdout
    rule0201(fo, len(sys.argv) > 2)
    rule0202(fo, len(sys.argv) > 2)
