# -*- coding: iso-8859-1 -*-
__version__ = '1.0'

from common import level_rule
from FindFile import FindFile
from get_security import get_security

@level_rule(2)
def rule0302(fo, fmt):
    """ If the change was not approved by the system manager, then it 
signifies an unauthorized change was made to the file, and represents an area 
of vulnerability with regards to protection of critical files."""

    if not fmt:
        print>>fo
        print>>fo, 'Rule 0302'
        print>>fo, '========='

    with FindFile('SYS$SYSROOT:[000000...]*.*') as fi:
        for fn in fi:
            id = get_security (fn)[0]
            if (id != 'SYSTEM') and (id != '[1,1]'):
                if (fn != 'MOM$SYSTEM') and (id != '[376,375]'):
                    if fmt:
                        print>>fo, '03022', fn
                    else:
                        print>>fo, fn
                        print>>fo, ' ' * 10, id

if __name__ == '__main__':
    import sys
    fo = open(sys.argv[1], 'w') if len(sys.argv) > 1 else sys.stdout
    rule0302(fo, len(sys.argv) > 2)
