# -*- coding: iso-8859-1 -*-
__version__ = '1.0'

from common import level_rule
import os, os.path
from vms.rtl import lib
from vms import starlet
from vms import ossdef, ssdef, rmsdef, dvsdef, dcdef, dvidef, itemList
from vms import user
from vms import crtl
from FindFile import FindFile
from secrules import get_security
from DeviceScan import DeviceScan

@level_rule(2)
def rule0401(fo, fmt):
    """ The integrity of system files is critical to the security and 
integrity of the VMS operating environment.  Improperly defined ACLs can 
grant unintended access to files, which could result in the compromise of 
the operating environment, and/or compromise the confidentiality of customer 
data."""

    if not fmt:
        print>>fo
        print>>fo, 'Rule 0401'
        print>>fo, '========='
        
    def fileACL(root):
        it = [itemList.itemList (code=ossdef.OSS__ACL_LENGTH, dtype=itemList.il_unsignedLong),]
        with FindFile(root) as ifn:
            for fn in ifn:
                try:
                    retacl = starlet.get_security (objnam=fn, clsnam='FILE',itmlst=it)
                    acllen  = int(retacl[1][ossdef.OSS__ACL_LENGTH])
                    if (acllen != 0):
                        if fmt:
                            print>>fo, '04012', fn
                        else:
                            print>>fo, fn
                        for e in get_security.get_security (fn)[2]:
                            if not fmt:
                                print>>fo, ' '*9, e
                except VMSError, e:
                    if e.errno != rmsdef.RMS__FNF:
                        raise
    
    for device in DeviceScan('*', devclass=dcdef.DC__DISK):
        if not (lib.getdvi (dvidef.DVI__MNT, device_name=device)[1]):
            continue
        if lib.getdvi (dvidef.DVI__SHDW_MEMBER, device_name=device)[1]:
            continue
        fileACL(device + '[000000...]*.*')
    
@level_rule(2)
def rule0403(fo, fmt):
    """ From a security standpoint, this is extremely dangerous because 
it can render the disk unusable or the system inoperable because these 
files can be corrupted or deleted."""

    if not fmt:
        print>>fo
        print>>fo, 'Rule 0403'
        print>>fo, '========='
    
    def fileSYS(root):
        with FindFile(root) as fi:
            for fn in fi:
                own = get_security.get_security(fn)[0] 
                if own not in ('SYSTEM', '[1,1]'):
                    if fmt:
                        print>>fo, '04032', fn
                    else:
                        print>>fo, fn, own      

    devCtx = 0
    devItm = [itemList.itemList (code=dvsdef.DVS__DEVCLASS, value=dcdef.DC__DISK),]
    
    while(True): 
        try:
            sts,device,devCtx = starlet.device_scan('*', devItm, devCtx)
        except:
            break
        if not lib.getdvi (dvidef.DVI__MNT, device_name=device)[1]:
            continue
        if lib.getdvi(dvidef.DVI__SHDW_MEMBER, device_name=device)[1]:
            continue
        fileSYS(device + '[000000]*.SYS')

@level_rule(2)
def rule0404(fo, fmt):
    """ This presents a major security concern, as other users may potentially 
corrupt or delete these files which could render the disk unusable or the 
system inoperable."""

    if not fmt:
        print>>fo
        print>>fo, 'Rule 0404'
        print>>fo, '========='
    
    def fileSYSProt(root):
        with FindFile(root) as fi:
            for fn in fi:
                prot = get_security.get_security(fn)[1] 
                if not (prot == 'System: RWED, Owner: RWED, Group: RE, World'):
                    if fmt:
                        print>>fo, '04042', fn
                    else:
                        print>>fo, fn, prot
    
    devCtx = 0
    devItm = [itemList.itemList (code=dvsdef.DVS__DEVCLASS, value=dcdef.DC__DISK),]
    
    while(True): 
        try:
            sts,device,devCtx = starlet.device_scan('*', devItm, devCtx)
        except:
            break
        if not lib.getdvi (dvidef.DVI__MNT, device_name=device)[1]:
            continue
        if lib.getdvi(dvidef.DVI__SHDW_MEMBER, device_name=device)[1]:
            continue
        fileSYSProt(device + '[000000]*.SYS')

@level_rule(2)
def rule0405(fo, fmt):
    """ From a security standpoint, this is extremely dangerous because it 
can render the disk unusable or the system inoperable because these files can 
be corrupted or deleted by users which have the same identifier granted to 
them."""

    if not fmt:
        print>>fo
        print>>fo, 'Rule 0405'
        print>>fo, '========='
        
    def fileACLrf(fs):
        it = [itemList.itemList (code=ossdef.OSS__ACL_LENGTH, dtype=itemList.il_unsignedLong),]
        with FindFile (fs) as ifn:
            for fn in ifn:
                acllen = int (starlet.get_security (objnam=fn, clsnam='FILE',itmlst=it)[1][ossdef.OSS__ACL_LENGTH])
                if (acllen != 0):
                    if fmt:
                        print>>fo, '04052', fn
                    else:
                        print>>fo, fn
                    for e in get_security.get_security (fn)[2]:
                        if not fmt:
                            print>>fo, ' '*9, e
    
    for device in DeviceScan('*', devclass=dcdef.DC__DISK):
        if not (lib.getdvi (dvidef.DVI__MNT, device_name=device)[1]):
            continue
        if lib.getdvi (dvidef.DVI__SHDW_MEMBER, device_name=device)[1]:
            continue
        fileACLrf(device + '[000000]*.SYS')
    
if __name__ == '__main__':
    import sys
    fo = open(sys.argv[1], 'w') if len(sys.argv) > 1 else sys.stdout
    rule0401(fo, len(sys.argv) > 2)
    rule0403(fo, len(sys.argv) > 2)
    rule0404(fo, len(sys.argv) > 2)
    rule0405(fo, len(sys.argv) > 2)
