# -*- coding: iso-8859-1 -*-
__version__ = '1.0'

from common import level_rule
import os, os.path
from vms.rtl import lib
from vms import syidef, uaidef, prvdef, dvidef, ossdef
from vms import user
from vms import starlet
from vms import itemList
from vms import crtl

maxsysgroup = lib.getsyi(syidef.SYI__MAXSYSGROUP)[1]
all_users = user.all_users()

@level_rule(3)
def rule0501(fo, fmt):
    """ Not having the DISCTLY flag not set allows these accounts to 
prematurely abort the system login sequence.  This may prevent certain 
procedures from being executed during login which may be required for this 
site."""

    if not fmt:
        print>>fo, 'Rule 0501'
        print>>fo, '========='

    for u in all_users.values():
        if not (u.flags & uaidef.UAI_M_DISCTLY):
            if fmt:
                print>>fo, '05013', u.username
            else:
                print>>fo, u.username

@level_rule(3)
def rule0502(fo, fmt):
    """Ensure the DISCTLY flag is set on all accounts."""

    if not fmt:
        print>>fo, ''
        print>>fo, 'Rule 0502'
        print>>fo, '========='

    for u in all_users.values():
        if not (u.flags & uaidef.UAI_M_DEFCLI):
            if fmt:
                print>>fo, '05023', u.username
            else:
                print>>fo, u.username

@level_rule(2)
def rule0503(fo, fmt):
    """ A captive account rarely requires elevated privileges, nor should 
it be assigned a system level UIC.  In addition, it is recommended that a 
user of a captive account not be allowed to change the password for that 
account -- The LOCKPWD flag should be set."""

    if not fmt:
        print>>fo, ''
        print>>fo, 'Rule 0503'
        print>>fo, '========='

    for u in all_users.values():
        if (u.flags & uaidef.UAI_M_CAPTIVE):
            if (u.flags & uaidef.UAI_M_LOCKPWD) or (u.uic_group <= maxsysgroup):
                if fmt:
                    print>>fo, '05032', u.username
                else:
                    print>>fo, u.username, u.uic_group

@level_rule(2)
def rule0504(fo, fmt):
    """ A restricted account rarely requires elevated privileges, nor should 
it be assigned a system level UIC.  In addition, its PRCLM quota should be 
set to zero in order to prevent such a user to spawn out of the restricted 
environment."""

    if not fmt:
        print>>fo, ''
        print>>fo, 'Rule 0504'
        print>>fo, '========='

    for u in all_users.values():
        if (u.flags & uaidef.UAI_M_CAPTIVE) and ((u.uic_group <= maxsysgroup) or (u.prccnt != 0)):
            if fmt:
                print>>fo, '05042', u.username
            else:
                print>>fo, u.username, u.uic_group, u.prccnt

@level_rule(2)
def rule0506(fo, fmt):
    """ Unused accounts can present opportunities to penetrate the system.  
These accounts have never been utilized on the system.  This implies that 
these accounts are inactive and, therefore, may be unnecessary.  They also 
present a potential security risk in that unauthorized users may attempt to 
gain access to the system using these accounts."""

    if not fmt:
        print>>fo, ''
        print>>fo, 'Rule 0506'
        print>>fo, '========='

    for u in all_users.values():
        if (u.lastlogin_i == 0) and (u.lastlogin_n == 0) and not (u.flags & uaidef.UAI_M_DISACNT):
            if fmt:
                print>>fo, '05062', u.username
            else:
                print>>fo, u.username

@level_rule(2)
def rule0507(fo, fmt):
    """ Stale accounts can present opportunities to penetrate the system.   
These may be stale accounts which are no longer needed.  They may also be 
utilized as a means to gain unauthorized access to the system."""

    if not fmt:
        print>>fo, ''
        print>>fo, 'Rule 0507'
        print>>fo, '========='

    delta_time = starlet.bintim("90 00:00:00.00")[1]
    current_time = starlet.bintim(starlet.asctim()[1])[1]
    limit_time = current_time + delta_time
    for u in all_users.values():
        if ((u.lastlogin_i < limit_time) and (u.lastlogin_n < limit_time )) and not (u.flags & uaidef.UAI_M_DISACNT):
            if fmt:
                print>>fo, '05072', u.username
            else:
                print>>fo, u.username

@level_rule(3)
def rule0508(fo, fmt):
    """ Improperly defined and maintained user accounts presents opportunities 
to penetrate the system, thus giving an unauthorized user access to the system 
resources."""

    if not fmt:
        print>>fo, ''
        print>>fo, 'Rule 0508'
        print>>fo, '========='

    for u in all_users.values():
        if (u.flags & uaidef.UAI_M_DISACNT):
            if fmt:
                print>>fo, '05083', u.username
            else:
                print>>fo, u.username

@level_rule(3)
def rule0509(fo, fmt):
    """ Improperly defined and maintained user accounts present opportunities 
to penetrate the system, thus giving an unauthorized user access to the system 
resources."""

    if not fmt:
        print>>fo, ''
        print>>fo, 'Rule 0509'
        print>>fo, '========='

    for u in all_users.values():
        if (0 < u.expiration < current_time):
            if fmt:
                print>>fo, '05093', u.username
            else:
                print>>fo, u.username

@level_rule(2)
def rule0510(fo, fmt):
    """ Login related SYGEN parameters define and enforce the login policies 
of the site.  Improperly defined Login related SYSGEN parameters can result 
in the compromise of the operating system environment, and compromise the 
confidentiality of customer data."""

    if not fmt:
        print>>fo, ''
        print>>fo, 'Rule 0510'
        print>>fo, '========='

    lst = (("LGI_BRK_TERM", syidef.SYI__LGI_BRK_TERM, 0, 0),
           ("LGI_BRK_DISUSER", syidef.SYI__LGI_BRK_DISUSER, 0, -1, 1), 
           ("LGI_PWD_TMO", syidef.SYI__LGI_PWD_TMO, 30, -1, 0),
           ("LGI_RETRY_LIM", syidef.SYI__LGI_RETRY_LIM, 3, -1, 0),
           ("LGI_RETRY_TMO", syidef.SYI__LGI_RETRY_TMO, 10, 1, 0),
           ("LGI_BRK_LIM", syidef.SYI__LGI_BRK_LIM, 3, -1, 0),
           ("LGI_BRK_TMO", syidef.SYI__LGI_BRK_TMO, 300, -1, 0),
           ("LGI_HID_TIM", syidef.SYI__LGI_HID_TIM, 10, -1, 0),
           ("LGI_CALLOUTS", syidef.SYI__LGI_CALLOUTS, 0, 0),
          )

    for p in lst:
        r = lib.getsyi(p[1])[1]
        if cmp(r, p[2]) not in p[3:]:
            if fmt:
                print>>fo, '05102', p[0]
            else:
                print>>fo, p[0]
    
if __name__ == '__main__':
    import sys
    fo = open(sys.argv[1], 'w') if len(sys.argv) > 1 else sys.stdout
    rule0501(fo, len(sys.argv) > 2)
    rule0502(fo, len(sys.argv) > 2)
    rule0503(fo, len(sys.argv) > 2)
    rule0504(fo, len(sys.argv) > 2)
    rule0506(fo, len(sys.argv) > 2)
    rule0507(fo, len(sys.argv) > 2)
    rule0508(fo, len(sys.argv) > 2)
    rule0509(fo, len(sys.argv) > 2)
    rule0510(fo, len(sys.argv) > 2)
