# -*- coding: iso-8859-1 -*-
__version__ = '1.0'

from common import level_rule
import os
from vms import starlet
from vms.rtl import lib
from vms import syidef
from DisplayProxy import DisplayProxy
from user_exists import user_exists
from FindFile import FindFile, file_exists

maxsysgroup = lib.getsyi(syidef.SYI__MAXSYSGROUP)[1]

        
@level_rule(2)
def rule0601(fo, fmt):
    """ Improper definition of the network can present opportunities to 
penetrate the system.  This is a serious security vulnerability since it 
allows access from nodes not currently added to the network."""

    if not fmt:
        print>>fo
        print>>fo, 'Rule 0601'
        print>>fo, '========='

    for proxy_node, proxy_user, default_user, local_users in DisplayProxy():
        if '*' in (proxy_node, proxy_user):
            if fmt:
                print>>fo, '06012', proxy_node, proxy_user
            else:
                print>>fo, proxy_node, proxy_user, default_user, local_users    

@level_rule(2)
def rule0602(fo, fmt):
    """ Improper definition of the network can present opportunities to 
penetrate the system.  This inconsistency indicates either a potential denial 
of service attack, or a potential for unintended access given to a future 
user."""

    if not fmt:
        print>>fo
        print>>fo, 'Rule 0602'
        print>>fo, '========='

    for proxy_node, proxy_user, default_user, local_users in DisplayProxy():
        if (default_user != '*') and (default_user != ''):
            if user_exists(default_user)[0] is None:
                if fmt:
                    print>>fo, '06022', proxy_node, proxy_user
                else:
                    print>>fo, '1', proxy_node, proxy_user, default_user
                    print>>fo, proxy_node, proxy_user, default_user, local_users    
        for l in local_users:
            if (l != '*') and (l != ''):
                if user_exists(l)[0] is None:
                    if fmt:
                        print>>fo, '0602', proxy_node, proxy_user
                    else:
                        print>>fo, '2', proxy_node, proxy_user, l
                        print>>fo, proxy_node, proxy_user, default_user, local_users    

@level_rule(2)
def rule0603(fo, fmt):
    """ This is a serious vulnerability because it allows privileged operations 
to occur remotely without the user even logging in."""

    if not fmt:
        print
        print>>fo, 'Rule 0603'
        print>>fo, '========='

    for proxy_node, proxy_user, default_user, local_users in DisplayProxy():
        if (default_user != '*') and (default_user != ''):
            g, m =  user_exists(default_user)
            if (g is not None) and (g <= maxsysgroup):
                if fmt:
                    print>>fo, '06032', proxy_node, proxy_user
                else:
                    print>>fo, proxy_node, proxy_user, default_user
        for l in local_users:
            if (l != '*') and (l != ''):
                g, m =  user_exists(local_users)
                if (g is not None) and (g <= maxsysgroup):
                    if fmt:
                        print>>fo, proxy_node, proxy_user
                    else:
                        print>>fo, proxy_node, proxy_user, l    

@level_rule(2)
def rule0604(fo, fmt):
    """ This inconsistency indicates either a potential denial of service 
attack, or a potential for unintended enabling of the object in the future."""

    if not fmt:
        print>>fo
        print>>fo, 'Rule 0604'
        print>>fo, '========='

    with os.popen('@USER_TASK.COM') as p:
        r = [x[:-1].split(',') for x in p]

    for t, u, i in r:
        if user_exists(u)[0] is None:
            if fmt:
                print>>fo, '06042', t, u
            else:
                print>>fo, t, u

@level_rule(2)
def rule0605(fo, fmt):
    """ This is a serious vulnerability because it allows privileged 
operations to occur remotely without the user even logging in."""

    if not fmt:
        print>>fo
        print>>fo, 'Rule 0605'
        print>>fo, '========='

    with os.popen('@USER_TASK.COM') as p:
        r = [x[:-1].split(',') for x in p]

    for t, u, i in r:
        g, m =  user_exists(u)
        if (g is not None) and (g <= maxsysgroup):
            if fmt:
                print>>fo, '06052', t, u
            else:
                print>>fo, t, u

@level_rule(3)
def rule0606(fo,fmt):
    """ Network object executable does not exist. This prevents the network
object from being used."""

    if not fmt:
        print>>fo
        print>>fo, 'Rule 0606'
        print>>fo, '========='

    with os.popen('@USER_TASK.COM') as p:
        r = [x[:-1].split(',') for x in p]

    for t, u, i in r:
        if not file_exists(i):
            if fmt:
                print>>fo, '06063', t, u, i
            else:
                print>>fo, t, u, i
     
@level_rule(3)
def rule0607(fo, fmt):
    """ This network object allows remote users to execute remotely any 
command procedure they specify, subject to normal access restrictions.  It is 
more secure to require all procedures that may be remotely executed to be 
previously defined in the network object VMS - OpenVMS by eliminating this 
object."""

    if not fmt:
        print>>fo
        print>>fo, 'Rule 0607'
        print>>fo, '========='

    with os.popen('@USER_TASK.COM') as p:
        r = [x[:-1].split(',') for x in p]

    for t, u, i in r:
        if (t == 'TASK'):
            if fmt:
                print>>fo, '06073', t, u, i
            else:
                print>>fo, t, u, i

if __name__ == '__main__':
    import sys
    fo = open(sys.argv[1], 'w') if len(sys.argv) > 1 else sys.stdout
    rule601(fo, len(sys.argv) > 2)
    rule602(fo, len(sys.argv) > 2)
    rule603(fo, len(sys.argv) > 2)
    rule604(fo, len(sys.argv) > 2)
    rule605(fo, len(sys.argv) > 2)
    rule606(fo, len(sys.argv) > 2)
    rule607(fo, len(sys.argv) > 2)
