# -*- coding: iso-8859-1 -*-
__version__ = '1.0'

from common import level_rule
from vms import starlet
from vms import user
from vms import uaidef

@level_rule(1)
def rule0801(fo, fmt):
    """ This condition allows immediate access to the system to anyone 
accessing these accounts.  In addition, if any of these accounts is a 
privileged account then the system is vulnerable to intentional or 
unintentional tampering with critical system resources."""

    if not fmt:
        print>>fo
        print>>fo, 'RULE 0801'
        print>>fo, '========='

    all_users = user.all_users()

    for u in all_users.values():
        if (u.pwd_length == 0):
            du = ''
            if (u.flags & uaidef.UAI_M_DISACNT):
                du = 'DisUser'
            if fmt:
                print>>fo, '08011', u.username, du
            else:
                print>>fo, u.username, u.pwd_length, du

@level_rule(2)
def rule0802(fo, fmt):
    """ Improper password definition and/or use, such as the use of 
predictable and easily guessed passwords, can present opportunities to 
penetrate the system.  The listed accounts have the DISPWDDIC flag set in 
their UAF record.  This prevents the system from screening use of a new 
password against a system dictionary when the user changes the password for 
the account.  This allows the same password to be used repetitively for the 
account which increases the risk of an unauthorized user guessing the password 
and thus gaining access to the system."""

    if not fmt:
        print>>fo
        print>>fo, 'RULE 0802'
        print>>fo, '========='

    all_users = user.all_users()

    for u in all_users.values():
        if (u.flags & uaidef.UAI_M_DISPWDDIC):
            du = ''
            if (u.flags & uaidef.UAI_M_DISACNT):
                du = 'DisUser'
            if fmt:
                print>>fo, '08022', u.username, du
            else:
                print>>fo, u.username, du

@level_rule(2)
def rule0803(fo, fmt):
    """ Improper password definition and/or use, such as failure to change 
passwords on a regular basis, can present opportunities to penetrate the 
system.  The listed accounts have the DISPWDHIS flag set in their UAF record.  
This prevents the system from verifying previous use of a new password when a 
user changes the password for the account.  This allows the same password to 
be used repetitively for the account, which increases the risk of an 
unauthorized user guessing the password and thus gaining access to the 
system."""

    if not fmt:
        print>>fo
        print>>fo, 'RULE 0803'
        print>>fo, '========='

    all_users = user.all_users()

    for u in all_users.values():
        if (u.flags & uaidef.UAI_M_DISPWDHIS):
            du = ''
            if (u.flags & uaidef.UAI_M_DISACNT):
                du = 'DisUser'
            if fmt:
                print>>fo, '08032', u.username, du
            else:
                print>>fo, u.username, du

@level_rule(2)
def rule0804(fo, fmt):
    """ Improper password definition and/or use, such as inadequate password 
length and complexity, can present opportunities to penetrate the system.  
The listed accounts have an improperly set PWDMINIMUM value, which allows 
them to use passwords with lengths which are less than the DISA standard of 
6 characters.  This increases the risk that the passwords for these accounts 
may be guessed thus allowing potential unauthorized access to the system."""

    if not fmt:
        print>>fo
        print>>fo, 'RULE 0804'
        print>>fo, '========='

    all_users = user.all_users()

    for u in all_users.values():
        if (u.pwd_length < 8):
            du = ''
            if (u.flags & uaidef.UAI_M_DISACNT):
                du = 'DisUser'
            if fmt:
                print>>fo, '08042', u.username, du
            else:
                print>>fo, u.username, u.pwd_length, du

@level_rule(2)
def rule0805(fo, fmt):
    """ Improper password definition and/or use, such as failure to change 
passwords on a regular basis, can present opportunities to penetrate the 
system.  An account with no password lifetime restriction may retain its 
password indefinitely.  This renders the account vulnerable to unauthorized 
access if its password is discovered by unauthorized users of that account.  
Those accounts with a password lifetime greater than the maximum specified 
may also be rendered vulnerable since they are not forced to change their 
password within 90 days."""

    if not fmt:
        print>>fo
        print>>fo, 'RULE 0805'
        print>>fo, '========='

    all_users = user.all_users()

    for u in all_users.values():
        if (u.pwd_lifetime > 90) or (u.pwd_lifetime == 0):
            du = ''
            if (u.flags & uaidef.UAI_M_DISACNT):
                du = 'DisUser'
            if fmt:
                print>>fo, '08052', u.username, du
            else:
                print>>fo, u.username, u.pwd_lifetime, du

if __name__ == '__main__':
    import sys
    fo = open(sys.argv[1], 'w') if len(sys.argv) > 1 else sys.stdout
    rule0801(fo, len(sys.argv) > 2)
    rule0802(fo, len(sys.argv) > 2)
    rule0803(fo, len(sys.argv) > 2)
    rule0804(fo, len(sys.argv) > 2)
    rule0805(fo, len(sys.argv) > 2)
