# -*- coding: iso-8859-1 -*-
__version__ = '1.0'

from common import level_rule
import os
from vms import starlet
from vms.rtl import lib
from vms import itemList
from vms import ossdef
from FindFile import FindFile, file_exists

@level_rule(2)
def rule0901(fo, fmt):
    """ The integrity of VMS startup files is critical to the security and 
integrity of the operating environment.  Improper access to startup files 
can allow unauthorized users to modify their own or another user's execution 
environment."""

    if not fmt:
        print>>fo
        print>>fo, 'RULE 0901'
        print>>fo, '========='

    it = [itemList.itemList (code=ossdef.OSS__PROTECTION, dtype=itemList.il_unsignedWord),]
    with FindFile ('Sys$Startup:*.*','') as ifn:
        for fn in ifn:
            prot = starlet.get_security (objnam=fn, clsnam='FILE', itmlst=it)[1][ossdef.OSS__PROTECTION]
            if not ((prot & 0x8000) and
                    (prot & 0x4000) and
                    (prot & 0x2000) and
                    (prot & 0x1000)):
                if fmt:
                    print>>fo, '09012', fn
                else:
                    print>>fo, fn
                    print>>fo,  ' ' * 10, lib.format_sogw_prot (prot)[1] 

@level_rule(3)
def rule0902(fo, fmt):
    """ During checking of the listed files for non-privileged access, either:  
1) An attempt to open the files to check for other called procedures resulted 
in an open failure,  -OR- 2) The listed command procedures reference other 
command procedures which were not found.  If a file was required and deleted, 
a user could create a file with the same name.  This file then would run with 
privileged access allowing a user to gain unauthorized system access."""

    if not fmt:
        print>>fo
        print>>fo, 'RULE 0902'
        print>>fo, '========='
    pok = True
    with os.popen('Search Sys$System:Startup.Log -FNF/Win=(1,0) /noHead') as p:
        for pi in p:
            if pok:
                if fmt:
                    print >>fo, '09023', pi,
                else:
                    print >>fo,  pi,
            pok = not pok

@level_rule(2)
def rule0903(fo, fmt):
    """ This indicates either a system configuration inconsistency or an 
inconsistency in the review criteria."""

    if not fmt:
        print>>fo
        print>>fo, 'RULE 0903'
        print>>fo, '========='

    lsf = ('SYS$SYSTEM:STARTUP.COM',
           'SYS$MANAGER:SYSTARTUP_VMS.COM',
           'SYS$SYSTEM:IA64VMSSYS.PAR')

    for fn in lsf:
        if not file_exists(fn):
            if fmt:
                print>>fo, '09032', fn
            else:
                print>>fo, fn

if __name__ == '__main__':
    import sys
    fo = open(sys.argv[1], 'w') if len(sys.argv) > 1 else sys.stdout
    rule0901(fo, len(sys.argv) > 2)
    rule0903(fo, len(sys.argv) > 2)
