# -*- coding: iso-8859-1 -*-
__version__ = '1.0'

from common import level_rule
import os

@level_rule(2)
def rule1001(fo, fmt):
    """ This prevents accounting history from being recorded."""

    if not fmt:
        print >>fo, 'RULE 1001'
        print >>fo, '========='
    with os.popen('SHOW ACCOUNTING') as p:
        r = [x[:-1] for x in p]

    for a in r:
        if 'enable' in a:
            break
        if 'disable' in a:
            if fmt:
                print >>fo, '10012 Accounting is disable'
            else:
                print >>fo,  'Accounting is disable'
                break

@level_rule(2)
def rule1002(fo, fmt):
    """ The related processes and events are not being recorded.  If system 
level access is not recorded, there is no way to track if an attack is being 
made to gain unauthorized access to the system."""

    if not fmt:
        print >>fo, 'RULE 1002'
        print >>fo, '========='
    f = False
    with os.popen('SHOW ACCOUNTING') as p:
        r = [x[:-1] for x in p]

    for a in r:
        if 'LOGIN_FAILURE' in a:
            f = True
    if not f:
        if fmt:
            print >>fo, '10022 LOGIN_FAILURE not accounted'
        else:
            print >>fo, 'LOGIN_FAILURE not accounted'

@level_rule(1)
def rule1003(fo, fmt):
    """ All system security alarms are currently disabled."""

    if not fmt:
        print >>fo, 'RULE 1003'
        print >>fo, '========='
    with os.popen('SHOW AUDIT/ALARM') as p:
        r = [x[:-1] for x in p]

    for a in r:
        if 'enable' in a:
            break
        if 'disable' in a:
            if fmt:
                print >>fo, '10031 Alarms auditing is disable'
            else:
                print >>fo, 'Alarms auditing is disable'
            break        

@level_rule(2)
def rule1004(fo, fmt):
    """ Some security alarms are not being reported."""

    if not fmt:
        print >>fo, 'RULE 1004'
        print >>fo, '========='
    with os.popen('SHOW AUDIT/ALARM') as p:
        r = [x[:-1] for x in p]
    brk = False
    acl = False
    for a in r:
        if 'Breakin:' in a:
            brk = True
        if 'ACL' in a:
            acl = True
    if not brk:
        if fmt:
            print >>fo, '10042 Breakin not audited (alarm)'
        else:
            print >>fo, 'Breakin not audited (alarm)'
    if not acl:
        if fmt:
            print >>fo, '10042 ACL not audited (alarm)'
        else:
            print >>fo, 'ACL not audited (alarm)'

@level_rule(1)
def rule1006(fo, fmt):
    """ Security alarms are not being reported.  Security infractions are not 
being recorded."""

    if not fmt:
        print >>fo, 'RULE 1006'
        print >>fo, '========='
    with os.popen('SHOW AUDIT/AUDIT') as p:
        r = [x[:-1] for x in p]

    for a in r:
        if 'enable' in a:
            break
        if 'disable' in a:
            if fmt:
                print >>fo, '10061 Report auditing is disable'
            else:
                print >>fo, 'Report auditing is disable'
            break        

@level_rule(2)
def rule1007(fo, fmt):
    """ Some security infractions are not being recorded."""

    if not fmt:
        print >>fo, 'RULE 1007'
        print >>fo, '=============='
    with os.popen('SHOW AUDIT/AUDIT') as p:
        r = [x[:-1] for x in p]

        brk = False
        brk_lst = 'Breakin not audited'
        acl = False
        aut = False
        lgf = False
        lgf_list = 'Logfailure not audited'

        for a in r:
            if 'ACL' in a:
                acl = True
            if 'Authorization' in a:
                aut = True
            if 'Breakin:' in a:
                brk_lst = a
                if 'dialup,local,remote,network,detached,server' in a:
                    brk = True
            if 'Logfailure' in a:
                lgf_list = a
                if 'batch,dialup,local,remote,network,subprocess,detached,server' in a:
                    lgf = True
        if not brk:
            if fmt:
                print >>fo, '10072', brk_lst
            else:
                print >>fo, brk_lst
        if not acl:
            if fmt:
                print >>fo, '10072 ACL not audited'
            else:
                print >>fo,  'ACL not audited'
        if not aut:
            if fmt:
                print >>fo, '10072 Authorization not audited'
            else:
                print >>fo, 'Authorization not audited'
        if not lgf:
            if fmt:
                print >>fo, '10072', lgf_list
            else:
                print lgf_list

if __name__ == '__main__':
    import sys
    fo = open(sys.argv[1], 'w') if len(sys.argv) > 1 else sys.stdout
    rule1001(fo, len(sys.argv) > 2)
    rule1002(fo, len(sys.argv) > 2)
    rule1003(fo, len(sys.argv) > 2)
    rule1004(fo, len(sys.argv) > 2)
    rule1006(fo, len(sys.argv) > 2)
    rule1007(fo, len(sys.argv) > 2)
