# -*- coding: iso-8859-1 -*-
__version__ = '1.0'

from common import level_rule
from vms import starlet
from vms.rtl import lib
from vms import queues, quidef

accname = lib.get_accnam('QUEUE')[1]

@level_rule(2)
def rule1201(fo, fmt):
    """ This allows the owner control over the queue and could lead to loss, or restriction, of service from this queue.  
By default, the printer and batch queues should be owned by the SYSTEM account."""

    if not fmt:
        print >>fo, 'RULE 1201'
        print >>fo, '========='
    for q in queues.all_queues():
        nam = q.queue_name 
        own = q.owner_uic
        g = int(own / 65536)
        m = int(own - (g *65536))
        if (g != 1) or (m != 4):
            if fmt:
                print >>fo, '12012', nam
            else:
                print >>fo, "%s [%o,%o]" % (nam, g, m)

@level_rule(2)
def rule1202(fo, fmt):
    """ This can lead to undesired or unauthorized manipulation of the queue such that service may be interrupted or 
compromised.  Queues should retain their default protection values as specified when initialized."""

    if not fmt:
        print >>fo, 'RULE 1202'
        print >>fo, '========='
    for q in queues.all_queues():
        nam = q.queue_name 
        prot = q.protection
        if (prot != 0xDE7B):
            if fmt:
                print >>fo, '12022', nam
            else:
                prt = lib.format_sogw_prot(prot, access_names=accname)[1]
                print >>fo, nam, prt

@level_rule(3)
def rule1203(fo, fmt):
    """ This denies print/batch service to users via these queues."""
    if not fmt:
        print >>fo, 'RULE 1203'
        print >>fo, '========='
    for q in queues.all_queues():
        nam = q.queue_name 
        qsts = q.queue_status
        if (qsts & quidef.QUI_M_QUEUE_STOPPED):
            if fmt:
                print >>fo, '12033', nam
            else:
                print >>fo, nam, 'Stopped'

if __name__ == '__main__':
    import sys
    fo = open(sys.argv[1], 'w') if len(sys.argv) > 1 else sys.stdout
    rule1201(fo, len(sys.argv) > 2)
    rule1202(fo, len(sys.argv) > 2)
    rule1203(fo, len(sys.argv) > 2)
