# -*- coding: iso-8859-1 -*-
__version__ = '1.0'

from common import level_rule
from vms import starlet
from vms.rtl import lib
from vms import user
from vms import rmsdef, ossdef
from vms import itemList
from FindFile import FindFile, file_exists

def path_exists(fn):
    try:
        with FindFile (fn, '') as ifn:
            ifn.__next__()
            return 1
    except StopIteration, e:
          return 3
    except VMSError, e:
        return 2

@level_rule(3)
def rule1301(fo, fmt):
    """ This condition precludes performing requested security checks for these users.  Either their home directories need 
to be added to the system, or the users may need to be removed from the SYSUAF if these are accounts which have expired and/or 
are no longer in use."""

    if not fmt:
        print >>fo, 'RULE 1301'
        print >>fo, '========='
    all_users = user.all_users()
    for u in all_users.values():
        if u.username == 'DEFAULT':
            if not fmt:
                print >>fo, 'skip default account'
            continue
        fn = u.defdev + u.defdir + '*.*'
        if (path_exists(fn) == 2):
            if fmt:
                print >>fo, '13013', fn
            else:
                print >>fo, fn, 'not exists', u.username

@level_rule(2)
def rule1303(fo, fmt):
    """ This makes these files potentially vulnerable to access, modification, or deletion by unauthorized users.  The methods 
of access may be available via an ACL on the file, the files UIC protection, and/or user access via the directory path or user 
privileges.  If GROUP is displayed, then there are non-privileged users in the same group as the file owner, which have the 
listed accesses to the file."""

    if not fmt:
        print >>fo, 'RULE 1303'
        print >>fo, '========='
    all_users = user.all_users()
    it = [itemList.itemList (code = ossdef.OSS__PROTECTION, dtype = itemList.il_unsignedWord),]
    for u in all_users.values():
        fn = u.defdev+u.defdir+'*.*'
        if (path_exists(fn)== 1):
            sep  = (u.defdev+u.defdir)[-1:]
            arbo = (u.defdev+u.defdir)[:-1]+'...' + sep + '*.*'
            with FindFile(arbo, '')as ifn:
                 for f in ifn:
                    try:
                        retsec = starlet.get_security(objnam=f, clsnam='FILE',itmlst=it)
                        prot = retsec[1][ossdef.OSS__PROTECTION]
                        if ((prot & 0x8000) or
                            (prot & 0x4000) or
                            (prot & 0x2000) or
                            (prot & 0x1000) or
                            (prot & 0x800) or
                            (prot & 0x400) or
                            (prot & 0x200) or
                            (prot & 0x100)):
                                if fmt:
                                    print >>fo, '13032', f
                                else:
                                    print >>fo, f
                                    print >>fo, ' ' * 10, lib.format_sogw_prot (prot)[1]
                    except VMSError, e:
                        if e.errno != rmsdef.RMS__FNF:
                            raise

@level_rule(2)
def rule1304(fo, fmt):
    """ Improper ownership may prevent these users from accessing their directories, and may allow the owner full reign on 
the files in the directory, and possibly all files in the directory tree."""

    if not fmt:
        print >>fo, 'RULE 1304'
        print >>fo, '========='
    it = [itemList.itemList (code = ossdef.OSS__OWNER, dtype = itemList.il_unsignedLong),]
    all_users = user.all_users()
    for u in all_users.values():
        fn = u.defdev + u.defdir
        fn = fn[:-1].replace('<','[')
        d = fn.split('[')[1]
        fu = fn + '.-]' + d + '.DIR'
        if not file_exists(fu):
            continue
        own = starlet.get_security(objnam=fu, clsnam='FILE', itmlst=it)[1][ossdef.OSS__OWNER]        
        high = int(own / 65536)
        low = int(own - high * 65536)
        if high != u.uic_group or low != u.uic_member:
            mark = '*' if high == 1 and low in (1, 4) else ''
            if fmt:
                print >>fo, '13042', mark, u.username
            else:
                print >>fo,  mark, u.username

@level_rule(3)
def rule1310(fo, fmt):
    """ This could prevent the user accounts from functioning properly.  It could indicate a denial of service situation."""

    if not fmt:
        print >>fo, 'RULE 1310'
        print >>fo, '========='
    all_users = user.all_users()
    for u in all_users.values():
        df = u.defdev + u.defdir + '*.*' 
        lgicmd = ''
        try:
            with FindFile (u.lgicmd if u.lgicmd != '' else 'LOGIN.COM', df) as fi:
                for f in fi:
                    lgicmd = f
                    break 
        except VMSError, e:
            continue 
        if lgicmd == '' or not file_exists(lgicmd):
            if fmt:
                print >>fo, '13103', u.username  
            else:
                print >>fo, u.username,lgicmd

if __name__ == '__main__':
    import sys
    fo = open(sys.argv[1], 'w') if len(sys.argv) > 1 else sys.stdout
    rule1301(fo, len(sys.argv) > 2)
    rule1303(fo, len(sys.argv) > 2)
    rule1304(fo, len(sys.argv) > 2)
    rule1310(fo, len(sys.argv) > 2)
