# -*- coding: iso-8859-1 -*-

from common import level_rule
import os
from secrules import FindFile

__version__ = '1.0'

@level_rule(2)
def rule1401(fo, fmt):
    if not fmt:
        print >>fo, 'RULE 1401'
        print >>fo, '========='

    with os.popen('install list/full') as p:
        r = [x[:-1].rstrip() for x in p]
    dspec = None
    fspec = None
    priv = None
    auth = None
    hasPriv = False
    instr = False
    state = 0
    for l in r:
        if (l == ''):
            continue
        if l[0] != ' ':
            dspec = l.replace('.000000','')
            fspec = None
        elif ';' in l:
            priv = auth = None
            hasPriv = False
            l = l.split()
            fspec = l[0]
            instr = len(l) > 1
            if instr:
                l = l[1:]
            if 'Prv' in l:
                hasPriv = True
        elif not instr:
            l = l.split()
            if 'Prv' in l:
                hasPriv = True
        elif 'Privileges = ' in l:
            priv = l
        elif 'Authorized = ' in l:
            auth = l
            with FindFile.FindFile(fspec, dspec) as fi:
                for f in fi:
                    if hasPriv:
                        if fmt:
                            print >>fo, '14012', f
                        else:
                            print >>fo, f
                            if priv: print >>fo, priv
                            if auth: print >>fo, auth

if __name__ == '__main__':
    import sys
    fo = open(sys.argv[1], 'w') if len(sys.argv) > 1 else sys.stdout
    rule1401(fo, len(sys.argv) > 2)
