# Supervisor-vms: A Process Control System for OpenVMS
Supervisor-vms is a tools that allows to monitor and control a number of processes on OpenVMS systems.

Use process termination mailbox and AST. No CPU usage if no event occurs.

- [Supervisor-vms: A Process Control System for OpenVMS](#supervisor-vms-a-process-control-system-for-openvms)
  - [Requirements](#requirements)
  - [Components](#components)
  - [Running supervisord](#running-supervisord)
    - [supervisord Command-Line Options](#supervisord-command-line-options)
  - [Running supervisorctl](#running-supervisorctl)
    - [supervisorctl Command-Line Options](#supervisorctl-command-line-options)
    - [supervisorctl Actions](#supervisorctl-actions)
  - [Configuration file](#configuration-file)
    - [File Format](#file-format)
    - [**\[supervisord\]** Section Settings](#supervisord-section-settings)
      - [**\[supervisord\]** Section Values](#supervisord-section-values)
    - [**\[program:x\]** Section Settings](#programx-section-settings)
      - [**\[program:x\]** Section Values](#programx-section-values)

It was inspired by *[supervisor](http://supervisord.org/)*

Read the supervisor documentation is probably a good idea. Many of configuration parameters are the same.

## Requirements
1. Python 3.10 (VSI version)
1. ovms module

Probably better to use the LD image which contains all the necessary modules.
## Components

All logicals are defined in table **SUPERVISORD_TABLE**

**supervisord.py**

The server piece of supervisor is named supervisord.<br>
It is responsible for starting  processes (programs) at its own invocation, responding to commands from clients, restarting crashed or exited processeses

The server process uses a configuration file.

**supervisorctl.py**

The command-line client piece of the supervisor is named supervisorctl.

It provides a shell-like interface to the features provided by supervisord.

From **supervisorctl**, a user can connect to the **supervisord** process, get status on the processes controlled by, stop and start processes of, and get lists of running processes (programs).

The command-line client talks to the server across a mailbox (SUPERVISORD_CMD logical)

## Running supervisord
Required privileges: **ALTPRI, SYSNAM, PRMMBX, IMPERSONATE, SETPRV, WORLD**

First create a **supervisord.conf**, you can use the template **supervisord.conf_template** as an example.

Then start **supervisord**, probably in **nodaemon** mode initially.

Finally, if all seem correct, shutdown it and restart it on daemon mode.

Running processes doesn't need to be stopped.<br>
When restarting **supervisord** find the necessary informations for running processes using the logical name table **SUPERVISORD_TABLE**.

### supervisord Command-Line Options
<dl>
<dt><strong>-c FILE, --configuration=FILE</strong></dt>
<dd>The path to a **supervisord** configuration file. Unix syntax should be used</dd>
<dt><strong>-n, --nodaemon</strong></dt>
<dd>Run supervisord in the foreground</dd>
<dt><strong>-p pwd, --password=pwd</strong></dt>
<dd>Optional password, used with <strong>supervisorctl</strong></dd>
<dt><strong>-h, --help</strong></dt>
<dd>Show supervisord command help</dd>
</dl>

## Running supervisorctl
Required privilege: **PRMMBX, SYSNAM**
### supervisorctl Command-Line Options
<dl>
<dt><strong>-c FILE, --configuration=FILE</strong></dt>
<dd>The path to a <strong>supervisord</strong> configuration file. Unix syntax should be used</dd>
<dt><strong>-p pwd, --password=pwd</strong></dt>
<dd>Optional password, used with <strong>supervisord</strong></dd>
<dt><strong>-h, --help</strong></dt>
<dd>Show supervisord command help</dd>
</dl>

### supervisorctl Actions
<dl>
<dt><strong>help</strong></dt>
<dd>Print a list of available actions</dd>
<dt><strong>help &lt;action&gt;</strong></dt>
<dd>Print help for &lt;action&gt;</dd>
<dt><strong>start &lt;name&gt;</strong></dt>
<dd>Start a process</dd>
<dt><strong>start &lt;name&gt; &lt;name&gt;</strong></dt>
<dd>Start multiple processes</dd>
<dt><strong>start all</strong></dt>
<dd>Start all processes</dd>
<dt><strong>status</strong></dt>
<dd>Get all process status info.</dd>
<dt><strong>status &lt;name&gt;</strong></dt>
<dd>Get status on a single process by name</dd>
<dt><strong>status &lt;name&gt; &lt;name&gt;</strong></dt>
<dd>Get status on multiple named processes</dd>
<dt><strong>stop &lt;name&gt;</strong></dt>
<dd>Stop a process</dd>
<dt><strong>stop &lt;name&gt; &lt;name&gt;</strong></dt>
<dd>Stop multiple processes</dd>
<dt><strong>stop all</strong></dt>
<dd>Stop all processes</dd>
<dt><strong>shutdown</strong></dt>
<dd>Stop <strong>supervisord</strong>, don't stop processes</dd>
</dl>

## Configuration file
The Supervisor configuration file is conventionally named supervisord.conf. <br>
It is used by both **supervisord** and **supervisorctl**.

### File Format

**supervisord.conf** is a Windows-INI-style (Python ConfigParser) file.<br>
It has sections (each denoted by a **[header]**) and key / value pairs within the sections.<br>
The sections and their allowable values are described below.

### **[supervisord]** Section Settings
All pathname use a **OpenVMS** syntax.
#### **[supervisord]** Section Values
<dl>
<dt><strong>nodaemon</strong></dt>
<dd>If true, supervisord will start in the foreground instead of daemonizing<br>Default: false</dd>
<dt><strong>user</strong></dt>
<dd>OpenVMS account to run <strong>supervisord</strong> as a detach process (daemon mode).<br> Default: system</dd>
<dt><strong>command</strong></dt>
<dd>Command procedure which run supervisord.<br>Default: None, should be specified, can be build from the template 
supervisord.com_template</dd>
<dt><strong>stdout_file</strong></dt>
<dd>stdout of supervisord process.<br>Default: NLA0:</dd>
<dt><strong>logfile</strong></dt>
<dd>The path to the activity log of the supervisord process<br>Default: supervisord.log</dd>
</dl>

### **[program:x]** Section Settings
The configuration file must contain one or more program sections in order for supervisord to know which programs it should start and control.<br>
The header value is composite value.
<br>It is the word “program”, followed directly by a colon, then the program name.<br>
Read the *[$creprc](https://docs.vmssoftware.com/vsi-openvms-system-services-reference-manual-a-getuai/#JUN_147)* documentation may be useful.

#### **[program:x]** Section Values
<dl>
<dt><strong>image</strong></dt>
<dd>Name of the image to be activated in the newly created process<br>
Default: <strong>SYS$SYSTEM:LOGINOUT.EXE</strong></dd>
<dt><strong>command</strong></dt>
<dd>Equivalence name to be associated with the logical name SYS$INPUT in the logical name table of the created process<br>
Default: NLA0:</dd>
<dt><strong>process_name</strong></dt>
<dd>Process name to be assigned to the created process.<br>
Default: %(program_name)s</dd>
<dt><strong>user</strong></dt>
<dd>Instruct supervisord to use this OpenVMS user account as the account which runs the program.<br>
Default: None, mandatory</dd>
<dt><strong>autostart</strong></dt>
<dd></dd>
<dt><strong>stdout_file</strong></dt>
<dd></dd>
<dt><strong>stderr_file</strong></dt>
<dd></dd>
<dt><strong>startsecs</strong></dt>
<dd></dd>
<dt><strong>startretries</strong></dt>
<dd></dd>
<dt><strong>stopwaitsecs</strong></dt>
<dd></dd>
<dt><strong>kt_limit</strong></dt>
<dd></dd>
<dt><strong>baspri</strong></dt>
<dd></dd>
<dt><strong>nouaf</strong></dt>
<dd></dd>
<dt><strong>quotas</strong></dt>
<dd></dd>
<dt><strong>privileges</strong></dt>
<dd></dd>
<dt><strong>autorestart</strong></dt>
<dd></dd>
<dt><strong>exitcodes</strong></dt>
<dd></dd>
</dl>
