"""This demonstrates a minimal http upload CGI.
It can operate as a standard CGI or as a CGIplus script.
It accepts a GIF, JPEG or PNG file and displays it in the browser.
"""

import cgi
import cgitb; cgitb.enable()
import wasd;
import os, sys

HTML_TEMPLATE = """<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html><head><title>pyRTE_test4.py</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
</head><body><h1>pyRTE_test4.py</h1>
<form action="%(SCRIPT_NAME)s" method="POST" enctype="multipart/form-data">
Image file name: <input name="image_file" type="file"><br>
<input name="submit" type="submit">
</form>
</body>
</html>"""

def print_html_form ():
    """This prints out the html form. Note that the action is set to
      the name of the script which makes this is a self-posting form.
      In other words, this cgi both displays a form and processes it.
    """
    print "content-type: text/html\n"
    print HTML_TEMPLATE % {'SCRIPT_NAME':os.environ['SCRIPT_NAME']}

def display_uploaded_file (form_field):
    """This display an image file uploaded by an HTML form.
    """
    binout = open ("SYS$OUTPUT", "wb")
    form = cgi.FieldStorage()
    if not form.has_key(form_field): return
    fileitem = form[form_field]
    if not fileitem.file: return False
    if not fileitem.filename: return False
    filename = fileitem.filename.lower()
    if filename.rfind(".gif") != -1:
       binout.write ("content-type: image/gif\n")
    elif filename.rfind(".jpg") != -1:
       binout.write ("content-type: image/jpeg\n")
    elif filename.rfind(".png") != -1:
       binout.write ("content-type: image/png\n")
    else:
       print "content-type: text/html\n"
       print "Only GIFs, JPEGs and PNGs handled by this test."
       return True

    binout.write ("expires: 01 Jan 2005 00:00:00 GMT\n\n")
    while 1:
        chunk = fileitem.file.read(100000)
        if not chunk: break
        binout.write (chunk)

    binout.close()
    del fileitem

    return True

while wasd.cgiplus_begin(True):
   if os.environ["REQUEST_METHOD"] == "POST":
      display_uploaded_file ("image_file")
   else:
      print_html_form ()
